/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPByteArraySP
extends PGPSignatureSubPacket {
    byte[] value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] value = in.readByteArray();
        if (value.length == 0) {
            throw new PGPDataFormatException("No data found.");
        }
        this.setValue(value);
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Packet data not initialized.");
        }
        out.writeFully(this.getValue());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPByteArraySP)) {
            return false;
        }
        PGPByteArraySP that = (PGPByteArraySP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("Array size == 0");
        }
        this.value = value;
    }
}

