/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz;

import java.util.Properties;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.ConnectorException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractConnector;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzConnector
extends AbstractConnector {
    public static final String QUARTZ = "quartz";
    public static final String PROPERTY_CRON_EXPRESSION = "cronExpression";
    public static final String PROPERTY_REPEAT_INTERVAL = "repeatInterval";
    public static final String PROPERTY_REPEAT_COUNT = "repeatCount";
    public static final String PROPERTY_START_DELAY = "startDelay";
    public static final String PROPERTY_PAYLOAD = "payload";
    public static final String PROPERTY_JOB_CONFIG = "jobConfig";
    public static final String PROPERTY_JOB_DATA = "jobData";
    public static final String PROPERTY_JOB_REF = "jobRef";
    public static final String PROPERTY_JOB_OBJECT = "jobObject";
    public static final String DEFAULT_GROUP_NAME = "mule";
    private Properties factoryProperties = null;
    private Scheduler quartzScheduler = null;

    protected void doInitialise() throws InitialisationException {
        if (this.factoryProperties == null) {
            this.factoryProperties = new Properties();
        }
        this.factoryProperties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        this.factoryProperties.setProperty("org.quartz.threadPool.threadCount", String.valueOf(this.getReceiverThreadingProfile().getMaxThreadsActive()));
        try {
            if (this.quartzScheduler == null) {
                StdSchedulerFactory factory = new StdSchedulerFactory(this.factoryProperties);
                this.quartzScheduler = factory.getScheduler();
            }
            this.quartzScheduler.getContext().put((Object)"mule.context", (Object)this.muleContext);
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.initialisationFailure((String)"Quartz conntector"), (Throwable)e, (Initialisable)this);
        }
    }

    protected void doDispose() {
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
        try {
            this.quartzScheduler.start();
        }
        catch (Exception e) {
            throw new ConnectorException(CoreMessages.failedToStart((String)"Quartz provider"), (Connector)this, (Throwable)e);
        }
    }

    protected void doStop() throws MuleException {
        try {
            if (this.quartzScheduler != null) {
                this.quartzScheduler.shutdown();
            }
        }
        catch (Exception e) {
            throw new ConnectorException(CoreMessages.failedToStop((String)"Quartz provider"), (Connector)this, (Throwable)e);
        }
    }

    public String getProtocol() {
        return QUARTZ;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void setQuartzScheduler(Scheduler scheduler) {
        this.quartzScheduler = scheduler;
    }

    public Properties getFactoryProperties() {
        return this.factoryProperties;
    }

    public void setFactoryProperties(Properties factoryProperties) {
        this.factoryProperties = factoryProperties;
    }
}

