/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.mule.agent.AgentSorter;
import org.mule.agent.MockAgent;
import org.mule.agent.MockAgent_A;
import org.mule.agent.MockAgent_B;
import org.mule.agent.MockAgent_C;
import org.mule.agent.MockAgent_D;
import org.mule.tck.AbstractMuleTestCase;

public class AgentSorterTestCase
extends AbstractMuleTestCase {
    public void testListWithoutDependencies() {
        MockAgent_A a = new MockAgent_A();
        MockAgent_B b = new MockAgent_B();
        MockAgent_C c = new MockAgent_C();
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(b);
        agents.add(c);
        List result = AgentSorter.sortAgents(agents);
        Assert.assertEquals((int)3, (int)result.size());
    }

    public void testSortWithSimpleDependency() {
        MockAgent_A a = new MockAgent_A();
        MockAgent_B b = new MockAgent_B();
        MockAgent_C c = new MockAgent_C(new Class[]{MockAgent_A.class});
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(b);
        agents.add(c);
        List result = AgentSorter.sortAgents(agents);
        Assert.assertEquals((int)3, (int)result.size());
        int indexOfA = result.indexOf(a);
        int indexOfC = result.indexOf(c);
        Assert.assertTrue((indexOfA < indexOfC ? 1 : 0) != 0);
    }

    public void testSortWithForwardDependency() {
        MockAgent_A a = new MockAgent_A(new Class[]{MockAgent_C.class});
        MockAgent_B b = new MockAgent_B();
        MockAgent_C c = new MockAgent_C();
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(b);
        agents.add(c);
        List result = AgentSorter.sortAgents(agents);
        Assert.assertEquals((int)3, (int)result.size());
        int indexOfA = result.indexOf(a);
        Assert.assertTrue((indexOfA > -1 ? 1 : 0) != 0);
        int indexOfC = result.indexOf(c);
        Assert.assertTrue((indexOfC > -1 ? 1 : 0) != 0);
        Assert.assertTrue((indexOfC < indexOfA ? 1 : 0) != 0);
    }

    public void testCyclicDependency() {
        MockAgent_A a = new MockAgent_A(new Class[]{MockAgent_B.class});
        MockAgent_B b = new MockAgent_B(new Class[]{MockAgent_A.class});
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(b);
        try {
            AgentSorter.sortAgents(agents);
            Assert.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testSortComplexDependencies() {
        MockAgent_A a = new MockAgent_A();
        MockAgent_B b = new MockAgent_B(new Class[]{MockAgent_A.class});
        MockAgent_C c = new MockAgent_C(new Class[]{MockAgent_B.class});
        MockAgent_D d = new MockAgent_D(new Class[]{MockAgent_A.class, MockAgent_C.class});
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(d);
        agents.add(c);
        agents.add(b);
        List result = AgentSorter.sortAgents(agents);
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertEquals((Object)a, result.get(0));
        Assert.assertEquals((Object)b, result.get(1));
        Assert.assertEquals((Object)c, result.get(2));
        Assert.assertEquals((Object)d, result.get(3));
    }

    public void testSortWithMissingDependency() {
        MockAgent_A a = new MockAgent_A();
        MockAgent_B b = new MockAgent_B(new Class[]{MockAgent_C.class});
        ArrayList<MockAgent> agents = new ArrayList<MockAgent>();
        agents.add(a);
        agents.add(b);
        List result = AgentSorter.sortAgents(agents);
        Assert.assertEquals((int)2, (int)result.size());
    }
}

