/*
 * Decompiled with CFR 0.152.
 */
package org.mule.expression;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.transformer.Transformer;
import org.mule.expression.MuleExpressionEvaluator;
import org.mule.expression.RegistryExpressionEvaluator;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.tck.testmodels.fruit.FruitBowlToFruitBasket;

public class MuleExpressionEvaluatorTestCase
extends AbstractMuleTestCase {
    private Map props;

    protected void doSetUp() throws Exception {
        MuleEvent event = MuleExpressionEvaluatorTestCase.getTestEvent((Object)"testing", MuleExpressionEvaluatorTestCase.getTestService("apple", Apple.class), (ImmutableEndpoint)MuleExpressionEvaluatorTestCase.getTestInboundEndpoint("test", "test://foo"));
        RequestContext.setEvent((MuleEvent)event);
        this.props = new HashMap(3);
        this.props.put("foo", "moo");
        this.props.put("bar", "mar");
        this.props.put("baz", "maz");
    }

    protected MuleMessage createMessageWithAttachments() {
        DefaultMuleMessage attahcmentsMessage = new DefaultMuleMessage((Object)"test", muleContext);
        try {
            attahcmentsMessage.addAttachment("foo", new DataHandler((DataSource)new StringDataSource("moo")));
            attahcmentsMessage.addAttachment("bar", new DataHandler((DataSource)new StringDataSource("mar")));
            attahcmentsMessage.addAttachment("baz", new DataHandler((DataSource)new StringDataSource("maz")));
        }
        catch (Exception e) {
            e.printStackTrace();
            MuleExpressionEvaluatorTestCase.fail((String)e.getMessage());
        }
        return attahcmentsMessage;
    }

    public void testSingleAttachment() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachment(foo)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = eval.evaluate("message.attachment(foo?)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = eval.evaluate("message.attachment(fool?)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = eval.evaluate("message.attachments(fool)", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Atachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapAttachmentss() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments(foo, baz)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = eval.evaluate("message.attachments(fool?)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("message.attachments(foo?, baz)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("foo");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        try {
            result = eval.evaluate("message.attachments(fool)", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Attachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListAttachments() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments-list(foo, baz)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = eval.evaluate("message.attachments-list(fool?)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = eval.evaluate("message.attachments-list(foo?, baz)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(0);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = eval.evaluate("message.attachments-list(fool?)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        try {
            result = eval.evaluate("message.attachments-list(fool)", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Atachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSingleAttachmentUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(foo)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(foo?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof DataHandler));
        baos = new ByteArrayOutputStream(4);
        ((DataHandler)result).writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(fool?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.attachment(fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Attachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMapAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, baz)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        DataHandler dh = (DataHandler)((Map)result).get("foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo?, baz)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("foo") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("foo");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("baz"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((Map)result).get("baz") instanceof DataHandler));
        dh = (DataHandler)((Map)result).get("baz");
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, fool?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull(((Map)result).get("foo"));
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(foo, fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Atachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo,baz)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        DataHandler dh = (DataHandler)((List)result).get(0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(fool?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo?,baz)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(0);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"moo", (String)baos.toString());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(1) instanceof DataHandler));
        dh = (DataHandler)((List)result).get(1);
        baos = new ByteArrayOutputStream(4);
        dh.writeTo((OutputStream)baos);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"maz", (String)baos.toString());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(fool?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo, fool?)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(((List)result).get(0) instanceof DataHandler));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((List)result).size());
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(foo, fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Attachment 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testGettingAllAttachments() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate("message.attachments(*)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        result = eval.evaluate("message.attachments-list(*)", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }

    public void testGettingAllAttachmentsUsingManager() throws Exception {
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments(*)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.attachments-list(*)]", this.createMessageWithAttachments());
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }

    public void testSingleHeader() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.header(foo)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("message.header(foo?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = eval.evaluate("message.header(fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.header(fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testMapHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers(foo, baz)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = eval.evaluate("message.headers(foo?, baz)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("message.headers(foo, fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", ((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((Map)result).size());
        try {
            result = eval.evaluate("message.headers(foo, fool)", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testListHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers-list(foo, baz)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("message.headers-list(foo?, baz)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = eval.evaluate("message.headers(fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = eval.evaluate("message.headers-list(foo, fool?)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", ((List)result).get(0));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((List)result).size());
        try {
            result = eval.evaluate("message.headers-list(foo, fool)", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testGettingAllHeaders() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = eval.evaluate("message.headers(*)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        result = eval.evaluate("message.headers-list(*)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }

    public void testGettingAllHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(*)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(*)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)3, (int)((List)result).size());
    }

    public void testSingleHeaderUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.header(foo)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.header(foo?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.header(fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.header(fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMapHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, baz)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo?, baz)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((Map)result).values().contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((Map)result).values().contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", ((Map)result).get("foo"));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((Map)result).size());
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(foo, fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testListHeadersUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", this.props, muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, baz)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((List)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo?, baz)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((List)result).size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("moo"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)((List)result).contains("maz"));
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)((List)result).contains("mar"));
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers(fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((int)0, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, fool?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof List));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"moo", ((List)result).get(0));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((List)result).size());
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.headers-list(foo, fool)]", this.createMessageWithAttachments());
            MuleExpressionEvaluatorTestCase.fail((String)"Header 'fool' is not on the nessage and not defined as optional");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testContextExpressions() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleExpressionEvaluator extractor = new MuleExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("context.serviceName", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"apple", (Object)o);
        o = extractor.evaluate("context.modelName", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = extractor.evaluate("context.inboundEndpoint", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"test://foo", (String)o.toString());
        o = extractor.evaluate("context.serverId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = extractor.evaluate("context.clusterId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = extractor.evaluate("context.domainId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = extractor.evaluate("context.workingDir", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        try {
            o = extractor.evaluate("context.bork", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testContextExpressionsFromExtractorManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object o = muleContext.getExpressionManager().evaluate("mule:context.serviceName", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"apple", (Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.modelName", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.inboundEndpoint", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertEquals((String)"test://foo", (String)o.toString());
        o = muleContext.getExpressionManager().evaluate("mule:context.serverId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.clusterId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.domainId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        o = muleContext.getExpressionManager().evaluate("mule:context.workingDir", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        try {
            o = muleContext.getExpressionManager().evaluate("mule:context.bork", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"bork is not a valid mule context value");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMissingEventContext() throws Exception {
        RequestContext.clear();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleExpressionEvaluator extractor = new MuleExpressionEvaluator();
        extractor.setMuleContext(muleContext);
        Object o = extractor.evaluate("context.serverId", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        try {
            o = extractor.evaluate("context.serviceName", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"There is no current event context");
        }
        catch (MuleRuntimeException e) {
            // empty catch block
        }
    }

    public void testMessagePropertiesUsingEvaluatorDirectly() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        Object result = eval.evaluate(null, (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)message, (Object)result);
        result = eval.evaluate(null, null);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("message.id", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)eval.evaluate("message.correlationId", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)new Integer(1), (Object)eval.evaluate("message.correlationSequence", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)new Integer(2), (Object)eval.evaluate("message.correlationGroupSize", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"foo", (Object)eval.evaluate("message.replyTo", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)e, (Object)eval.evaluate("message.exception", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"UTF-8", (Object)eval.evaluate("message.encoding", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)eval.evaluate("message.payload", (MuleMessage)message));
        try {
            eval.evaluate("message.xxx", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"message.xxx is not a supported expresion");
        }
        catch (Exception e1) {
            // empty catch block
        }
    }

    public void testMessagePropertiesUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        message.setCorrelationId(message.getUniqueId());
        message.setCorrelationSequence(1);
        message.setCorrelationGroupSize(2);
        message.setReplyTo((Object)"foo");
        message.setEncoding("UTF-8");
        Exception e = new Exception("dummy");
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)e));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.id]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)message.getUniqueId(), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationId]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)new Integer(1), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationSequence]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)new Integer(2), (Object)muleContext.getExpressionManager().evaluate("#[mule:message.correlationGroupSize]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"foo", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.replyTo]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)e, (Object)muleContext.getExpressionManager().evaluate("#[mule:message.exception]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"UTF-8", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.encoding]", (MuleMessage)message));
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)muleContext.getExpressionManager().evaluate("#[mule:message.payload]", (MuleMessage)message));
        try {
            muleContext.getExpressionManager().evaluate("#[mule:message.xxx]", (MuleMessage)message, true);
            MuleExpressionEvaluatorTestCase.fail((String)"xxx is not a supported expresion");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testMessagePayloadWithNulls() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object result = eval.evaluate(null, null);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
    }

    public void testMessagePayloadWithNullsUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        MuleExpressionEvaluatorTestCase.assertFalse((boolean)muleContext.getExpressionManager().isValidExpression("${payload:}"));
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[mule:message.payload]"));
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"test", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.payload]", null);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
    }

    public void testMessagePayloadWithTransform() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = eval.evaluate("message.payload(byte[])", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof byte[]));
        MuleExpressionEvaluatorTestCase.assertEquals((String)"test", (String)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = eval.evaluate("message.payload(java.lang.String)", (MuleMessage)new DefaultMuleMessage((Object)bais, muleContext));
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"test2", (Object)result);
    }

    public void testMessagePayloadWithTransformUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", muleContext);
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(byte[])]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof byte[]));
        MuleExpressionEvaluatorTestCase.assertEquals((String)"test", (String)new String((byte[])result));
        ByteArrayInputStream bais = new ByteArrayInputStream("test2".getBytes());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(java.lang.String)]", (MuleMessage)new DefaultMuleMessage((Object)bais, muleContext));
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"test2", (Object)result);
    }

    public void testMessagePayloadWithMoreComplexTransform() throws Exception {
        MuleExpressionEvaluator eval = new MuleExpressionEvaluator();
        eval.setMuleContext(muleContext);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = eval.evaluate("message.payload(org.mule.tck.testmodels.fruit.FruitBasket)", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)fb.getFruit().size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasBanana());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasApple());
    }

    public void testMessagePayloadWithMoreComplexTransformUsingManager() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new FruitBowl(new Apple(), new Banana()), muleContext);
        muleContext.getRegistry().registerTransformer((Transformer)new FruitBowlToFruitBasket());
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.payload(org.mule.tck.testmodels.fruit.FruitBasket)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof FruitBasket));
        FruitBasket fb = (FruitBasket)result;
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)fb.getFruit().size());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasBanana());
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)fb.hasApple());
    }

    public void testMapPayloadUsingManager() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("foo", "far");
        map.put("boo", "bar");
        map.put("zoo", "zar");
        DefaultMuleMessage message = new DefaultMuleMessage(map, muleContext);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)muleContext.getExpressionManager().isValidExpression("#[mule:message.map-payload(foo)]"));
        Object result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"far", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertEquals((Object)"far", (Object)result);
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foot?)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNull((Object)result);
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool)]", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"Map payload does not contain property 'fool' but it is required");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo, boo)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(foo?, boo)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)2, (int)((Map)result).size());
        result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool?, boo)]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)result);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(result instanceof Map));
        MuleExpressionEvaluatorTestCase.assertEquals((int)1, (int)((Map)result).size());
        try {
            result = muleContext.getExpressionManager().evaluate("#[mule:message.map-payload(fool, boo)]", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"Map payload does not contain property 'fool' but it is required");
        }
        catch (ExpressionRuntimeException e) {
            // empty catch block
        }
    }

    public void testSimpleRegistryLookup() throws Exception {
        FruitBowlToFruitBasket trans = new FruitBowlToFruitBasket();
        trans.setName("bowlToBasket");
        muleContext.getRegistry().registerTransformer((Transformer)trans);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("bowlToBasket", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(o instanceof Transformer));
        o = eval.evaluate("XXbowlToBasket*", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNull((Object)o);
        try {
            o = eval.evaluate("XXbowlToBasket", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"Object is not optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void testSimpleRegistryLookupUsingMAnager() throws Exception {
        FruitBowlToFruitBasket trans = new FruitBowlToFruitBasket();
        trans.setName("bowlToBasket");
        muleContext.getRegistry().registerTransformer((Transformer)trans);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        Object o = muleContext.getExpressionManager().evaluate("#[mule:registry.bowlToBasket]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNotNull((Object)o);
        MuleExpressionEvaluatorTestCase.assertTrue((boolean)(o instanceof Transformer));
        o = muleContext.getExpressionManager().evaluate("#[mule:registry.XXbowlToBasket*]", (MuleMessage)message);
        MuleExpressionEvaluatorTestCase.assertNull((Object)o);
        try {
            o = muleContext.getExpressionManager().evaluate("#[mule:registry.XXbowlToBasket]", (MuleMessage)message);
            MuleExpressionEvaluatorTestCase.fail((String)"Object is not optional");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected static class StringDataSource
    implements DataSource {
        protected String content;

        public StringDataSource(String payload) {
            this.content = payload;
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes());
        }

        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException("Read-only javax.activation.DataSource");
        }

        public String getContentType() {
            return "text/plain";
        }

        public String getName() {
            return "StringDataSource";
        }
    }
}

