/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model;

import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.service.Service;
import org.mule.tck.AbstractMuleTestCase;

public abstract class AbstractServiceTestCase
extends AbstractMuleTestCase {
    protected Service service;

    public void testStart() throws MuleException {
        try {
            this.service.start();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot start an uninitialised service");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.service.initialise();
        this.service.start();
        try {
            this.service.initialise();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot initialise an already initialised service");
        }
        catch (InitialisationException initialisationException) {
            // empty catch block
        }
        this.service.dispose();
    }

    public void testPause() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.resume();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.start();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.pause();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isPaused());
        this.service.pause();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isPaused());
        this.service.dispose();
    }

    public void testResume() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.resume();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.start();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.resume();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.pause();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isPaused());
        this.service.resume();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.resume();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.dispose();
    }

    public void testStop() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.stop();
        try {
            this.service.resume();
            AbstractServiceTestCase.fail((String)"Exception expected: Cannot stop an uninitialised service");
        }
        catch (MuleException muleException) {
            // empty catch block
        }
        this.service.initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.stop();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.start();
        AbstractServiceTestCase.assertTrue((boolean)this.service.isStarted());
        this.service.stop();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.stop();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.dispose();
    }

    public void testDispose() throws MuleException {
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        AbstractServiceTestCase.assertFalse((boolean)this.service.isPaused());
        this.service.dispose();
        this.service.initialise();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.dispose();
        AbstractServiceTestCase.assertFalse((boolean)this.service.isStarted());
        this.service.dispose();
    }
}

