/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mule.model;

import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.NoArgumentsEntryPointResolver;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.InvalidSatsuma;
import org.mule.transport.NullPayload;

public class NoArgsEntryPointResolverTestCase
extends AbstractMuleTestCase {
    public void testExplicitMethodMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("bite");
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        NoArgsEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testExplicitMethodMatch2() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        NoArgsEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testDynamicMethodMatchFail() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        NoArgsEntryPointResolverTestCase.assertEquals((String)"Apple service has a number of matching method, so should have failed", (int)result.getState(), (int)2);
    }

    public void testDynamicMethodMatchPass() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        NoArgsEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }

    public void testDynamicMethodMatchFailOnWildcardMatch() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        NoArgsEntryPointResolverTestCase.assertTrue((boolean)resolver.removeIgnoredMethod("is*"));
        InvocationResult result = resolver.invoke((Object)new InvalidSatsuma(), NoArgsEntryPointResolverTestCase.getTestEventContext("blah"));
        NoArgsEntryPointResolverTestCase.assertEquals((String)"Satsuma service has a number of matching method, so should have failed", (int)result.getState(), (int)2);
    }

    public void testExplicitMethodMatchAndNullPayload() throws Exception {
        NoArgumentsEntryPointResolver resolver = new NoArgumentsEntryPointResolver();
        resolver.addMethod("wash");
        InvocationResult result = resolver.invoke((Object)new Apple(), NoArgsEntryPointResolverTestCase.getTestEventContext(NullPayload.getInstance()));
        NoArgsEntryPointResolverTestCase.assertEquals((int)result.getState(), (int)1);
    }
}

