/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.api.MuleException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.concurrent.Latch;

public class RegisteredObjectLifecycleTestCase
extends AbstractMuleTestCase {
    private static final long TIMEOUT = 1000L;
    private Latch initLatch;
    private Latch startLatch;
    private Latch stopLatch;
    private Latch disposeLatch;
    private DummyBean bean = new DummyBean();

    protected void doSetUp() throws Exception {
        this.bean = new DummyBean();
        this.initLatch = new Latch();
        this.startLatch = new Latch();
        this.stopLatch = new Latch();
        this.disposeLatch = new Latch();
    }

    public void testLifecycleForMuleContext() throws Exception {
        muleContext.getRegistry().registerObject("dummy", (Object)this.bean);
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.initLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.start();
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.stop();
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.dispose();
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    public void testLifecycleForUnregisteredObject() throws Exception {
        muleContext.getRegistry().registerObject("dummy", (Object)this.bean);
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.initLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.start();
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.startLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertFalse((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
        muleContext.getRegistry().unregisterObject("dummy");
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.stopLatch.await(1000L, TimeUnit.MILLISECONDS));
        RegisteredObjectLifecycleTestCase.assertTrue((boolean)this.disposeLatch.await(1000L, TimeUnit.MILLISECONDS));
    }

    public class DummyBean
    implements Lifecycle {
        public String echo(String echo) {
            return echo;
        }

        public void initialise() throws InitialisationException {
            RegisteredObjectLifecycleTestCase.this.initLatch.countDown();
        }

        public void start() throws MuleException {
            RegisteredObjectLifecycleTestCase.this.startLatch.countDown();
        }

        public void stop() throws MuleException {
            RegisteredObjectLifecycleTestCase.this.stopLatch.countDown();
        }

        public void dispose() {
            RegisteredObjectLifecycleTestCase.this.disposeLatch.countDown();
        }
    }
}

