/*
 * Decompiled with CFR 0.152.
 */
package org.mule.registry;

import org.mule.api.registry.RegistrationException;
import org.mule.registry.AbstractLifecycleTracker;
import org.mule.registry.TransientRegistry;
import org.mule.tck.AbstractMuleTestCase;

public class TransientRegistryTestCase
extends AbstractMuleTestCase {
    public void testObjectLifecycle() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycle() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)1);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)1);
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassInjectors() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)2);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)2);
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleAndInjectors() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker, (Object)3);
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectBypassLifecycleAndInjectorsWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.initialise();
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker, (Object)3);
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleStates() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise]", (String)tracker.getTracker().toString());
        try {
            muleContext.initialise();
            TransientRegistryTestCase.fail((String)"context already initialised");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        try {
            muleContext.start();
            TransientRegistryTestCase.fail((String)"context already started");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.stop();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        try {
            muleContext.stop();
            TransientRegistryTestCase.fail((String)"context already stopped");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
        try {
            muleContext.dispose();
            TransientRegistryTestCase.fail((String)"context already disposed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testObjectLifecycleRestart() throws Exception {
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        muleContext.stop();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        muleContext.start();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleRestartWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        reg.fireLifecycle("start");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("stop");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("start");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start]", (String)tracker.getTracker().toString());
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testObjectLifecycleStatesWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext]", (String)tracker.getTracker().toString());
        reg.initialise();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("start");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("start");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("stop");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("stop");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
        reg.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleState() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStartFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("start");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStopFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("stop");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        reg.registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        reg.fireLifecycle("dispose");
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceDisposeFirstWithTransientRegistryDirectly() throws Exception {
        TransientRegistry reg = new TransientRegistry(muleContext);
        reg.fireLifecycle("dispose");
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            reg.registerObject("test", (Object)tracker);
            TransientRegistryTestCase.fail((String)"Cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    public void testLifecycleStateOutOfSequenceStartFirst() throws Exception {
        muleContext.start();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceStopFirst() throws Exception {
        muleContext.stop();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        muleContext.getRegistry().registerObject("test", (Object)tracker);
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop]", (String)tracker.getTracker().toString());
        muleContext.dispose();
        TransientRegistryTestCase.assertEquals((String)"[setMuleContext, initialise, start, stop, dispose]", (String)tracker.getTracker().toString());
    }

    public void testLifecycleStateOutOfSequenceDisposeFirst() throws Exception {
        muleContext.dispose();
        InterfaceBasedTracker tracker = new InterfaceBasedTracker();
        try {
            muleContext.getRegistry().registerObject("test", (Object)tracker);
            TransientRegistryTestCase.fail((String)"cannot register objects on a disposed registry");
        }
        catch (RegistrationException registrationException) {
            // empty catch block
        }
    }

    public class InterfaceBasedTracker
    extends AbstractLifecycleTracker {
    }
}

