/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters;

import org.mule.routing.filters.RegExFilter;
import org.mule.tck.AbstractMuleTestCase;

public class RegExFilterTestCase
extends AbstractMuleTestCase {
    public void testRegexFilterNoPattern() {
        RegExFilter filter = new RegExFilter();
        RegExFilterTestCase.assertNull((Object)filter.getPattern());
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"No tengo dinero"));
        filter.setPattern("(.*) brown fox");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        filter.setPattern(null);
        RegExFilterTestCase.assertFalse((boolean)filter.accept((Object)"oh-oh"));
    }

    public void testRegexFilter() {
        RegExFilter filter = new RegExFilter("The quick (.*)");
        RegExFilterTestCase.assertNotNull((Object)filter.getPattern());
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick "));
        RegExFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        RegExFilterTestCase.assertTrue((!filter.accept((Object)"he quick brown fox") ? 1 : 0) != 0);
        filter.setPattern("(.*) brown fox");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)" brown fox"));
        RegExFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        RegExFilterTestCase.assertTrue((!filter.accept((Object)"The quick brown fo") ? 1 : 0) != 0);
        filter.setPattern("(.*) brown (.*)");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"(.*) brown fox"));
        RegExFilterTestCase.assertTrue((!filter.accept((Object)"The quickbrown fox") ? 1 : 0) != 0);
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fo"));
        filter.setPattern("(.*)");
        RegExFilterTestCase.assertTrue((boolean)filter.accept((Object)"The quick brown fox"));
    }
}

