/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.component.Component;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.Router;
import org.mule.api.routing.RoutingException;
import org.mule.api.service.Service;
import org.mule.api.transport.OutputHandler;
import org.mule.component.simple.PassThroughComponent;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundPassThroughRouter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.NoActionTransformer;

public class DefaultOutboundRouterCollectionTestCase
extends AbstractMuleTestCase {
    private static int LATCH_AWAIT_TIMEOUT_MS = 1000;
    private Service testService;
    private MuleEvent testEvent;
    static MuleMessage originalMessage;
    private TestOutboundRouterCollection outboundRouter;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.testEvent = DefaultOutboundRouterCollectionTestCase.getTestInboundEvent("TEST_MESSAGE");
        this.testService = DefaultOutboundRouterCollectionTestCase.getTestService();
        this.testService.setComponent((Component)new PassThroughComponent());
        this.outboundRouter = new TestOutboundRouterCollection();
        this.testService.setOutboundRouter((OutboundRouterCollection)this.outboundRouter);
        this.outboundRouter.setMuleContext(muleContext);
    }

    public void testSingleDoesNotRequireCopyRouterMatchAllFalse() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(false);
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleDoesNotRequireCopyRouterMatchAllTrue() throws Exception {
        MuleEvent testEvent = DefaultOutboundRouterCollectionTestCase.getTestInboundEvent("TEST_MESSAGE");
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleRequiresCopyRouterMatchAllFalse() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(false);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testSingleRequiresCopyRouterMatchAllTrue() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(1);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleDoesNotRequireCopyRouterMatchAllFalse() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(false);
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleDoesNotRequireCopyRouterMatchAllTrue() throws Exception {
        MuleEvent testEvent = DefaultOutboundRouterCollectionTestCase.getTestInboundEvent("TEST_MESSAGE");
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleRequiresCopyRouterMatchAllFalse() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(false);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleRequiresCopyRouterMatchAllTrue() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestRequiresNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleMixMatchAllTrue() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(2);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testMultipleMixMatchAllFalse() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(false);
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(true));
        this.testService.getOutboundRouter().addRouter((Router)new TestDoesNotRequireNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestDoesNotRequireNewMessageOutboundRouter.latch = new CountDownLatch(3);
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(3);
        this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
        DefaultOutboundRouterCollectionTestCase.assertTrue((boolean)TestDoesNotRequireNewMessageOutboundRouter.latch.await((long)LATCH_AWAIT_TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    public void testStreamPayload() throws Exception {
        this.testService.getOutboundRouter().setMatchAll(true);
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.getOutboundRouter().addRouter((Router)new TestRequiresNewMessageOutboundRouter(false));
        this.testService.start();
        TestRequiresNewMessageOutboundRouter.latch = new CountDownLatch(2);
        this.testEvent.getMessage().setPayload((Object)new OutputHandler(){

            public void write(MuleEvent event, OutputStream out) throws IOException {
            }
        });
        MuleMessage result = this.testService.sendEvent(this.testEvent);
        DefaultOutboundRouterCollectionTestCase.assertTrue((result.getExceptionPayload() != null ? 1 : 0) != 0);
    }

    private static class TestOutboundRouterCollection
    extends DefaultOutboundRouterCollection {
        public MuleMessage route(MuleMessage message, MuleSession session) throws MessagingException {
            originalMessage = message;
            return super.route(message, session);
        }
    }

    private static class TestDoesNotRequireNewMessageOutboundRouter
    extends OutboundPassThroughRouter {
        static CountDownLatch latch;
        private boolean expectCopy;

        public TestDoesNotRequireNewMessageOutboundRouter(boolean expectCopy) {
            this.expectCopy = expectCopy;
        }

        public List getEndpoints() {
            ArrayList<OutboundEndpoint> list = new ArrayList<OutboundEndpoint>();
            try {
                list.add(AbstractMuleTestCase.getTestOutboundEndpoint("out", "test://out"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return list;
        }

        public boolean isMatch(MuleMessage message) throws RoutingException {
            if (this.expectCopy) {
                Assert.assertNotSame((Object)originalMessage, (Object)message);
            } else {
                Assert.assertSame((Object)originalMessage, (Object)message);
            }
            latch.countDown();
            return false;
        }

        public boolean isRequiresNewMessage() {
            return false;
        }
    }

    private static class TestRequiresNewMessageOutboundRouter
    extends OutboundPassThroughRouter {
        static CountDownLatch latch;
        private boolean expectCopy;

        public TestRequiresNewMessageOutboundRouter(boolean expectCopy) {
            this.expectCopy = expectCopy;
            ArrayList<NoActionTransformer> transformers = new ArrayList<NoActionTransformer>();
            transformers.add(new NoActionTransformer());
            this.setTransformers(transformers);
        }

        public List getEndpoints() {
            ArrayList<OutboundEndpoint> list = new ArrayList<OutboundEndpoint>();
            try {
                list.add(AbstractMuleTestCase.getTestOutboundEndpoint("out", "test://out"));
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            return list;
        }

        public boolean isMatch(MuleMessage message) throws RoutingException {
            if (this.expectCopy) {
                Assert.assertNotSame((Object)originalMessage, (Object)message);
            } else {
                Assert.assertSame((Object)originalMessage, (Object)message);
            }
            latch.countDown();
            return false;
        }
    }
}

