/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.routing.RoutingException;
import org.mule.routing.outbound.EndpointSelector;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class EndpointSelectorTestCase
extends AbstractMuleTestCase {
    Mock session;
    ImmutableEndpoint dest1;
    ImmutableEndpoint dest2;
    ImmutableEndpoint dest3;
    EndpointSelector router;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = MuleTestUtils.getMockSession();
        this.session.matchAndReturn("getService", (Object)EndpointSelectorTestCase.getTestService());
        this.dest1 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest1");
        this.dest2 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest2");
        this.dest3 = EndpointSelectorTestCase.getTestOutboundEndpoint("dest3");
        ArrayList<ImmutableEndpoint> endpoints = new ArrayList<ImmutableEndpoint>();
        endpoints.add(this.dest1);
        endpoints.add(this.dest2);
        endpoints.add(this.dest3);
        this.router = new EndpointSelector();
        this.router.setEndpoints(endpoints);
        this.router.setMuleContext(muleContext);
        this.router.initialise();
    }

    public void testSelectEndpointDefaultProperty() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("endpoint", "dest3");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.session.expect("dispatchEvent", C.eq((Object)message, (Object)this.dest3));
        this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        this.session.verify();
    }

    public void testSelectEndpointCustomProperty() throws Exception {
        this.router.setExpression("wayOut");
        this.router.setEvaluator("header");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("apple", "red");
        props.put("wayOut", "dest2");
        props.put("banana", "yellow");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.session.expect("dispatchEvent", C.eq((Object)message, (Object)this.dest2));
        this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        this.session.verify();
    }

    public void testSelectEndpointNoMatch() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("endpoint", "dest5");
        try {
            DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", props, muleContext);
            this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
            EndpointSelectorTestCase.fail((String)"Router should have thrown an exception if endpoint was not found.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSelectEndpointNoMatchUseDefault() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        this.router.setDefaultEndpointName("dest3");
        EndpointSelectorTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        this.session.expect("dispatchEvent", C.eq((Object)message, (Object)this.dest3));
        this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
        this.session.verify();
    }

    public void testSelectEndpointNoPropertySet() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        try {
            this.router.route((MuleMessage)message, (MuleSession)this.session.proxy());
            EndpointSelectorTestCase.fail((String)"Router should have thrown an exception if no selector property was set on the message.");
        }
        catch (RoutingException routingException) {
            // empty catch block
        }
    }
}

