/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.constraint.Constraint;
import com.mockobjects.dynamic.C;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ListMessageSplitter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.util.mock.PayloadClassConstraint;

public class ListMessageSplitterTestCase
extends AbstractMuleTestCase {
    public void testCorrelationGroupSizePropertySet() throws Exception {
        Service testService = ListMessageSplitterTestCase.getTestService("test", Apple.class);
        MuleSession session = ListMessageSplitterTestCase.getTestSession(testService, muleContext);
        OutboundEndpoint endpoint = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1Endpoint", "test://endpoint?synchronous=true");
        ListMessageSplitter router = new ListMessageSplitter();
        router.setFilter(null);
        router.addEndpoint(endpoint);
        router.setMuleContext(muleContext);
        ArrayList<String> payload = new ArrayList<String>();
        payload.add("one");
        payload.add("two");
        payload.add("three");
        payload.add("four");
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        MuleMessage result = router.route((MuleMessage)message, session);
        ListMessageSplitterTestCase.assertNotNull((Object)result);
        ListMessageSplitterTestCase.assertTrue((boolean)(result instanceof MuleMessageCollection));
        ListMessageSplitterTestCase.assertEquals((String)"There should be 4 results for 4 split messages.", (int)4, (int)((MuleMessageCollection)result).size());
    }

    public void testMessageSplitterRouter() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        OutboundEndpoint endpoint1 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test1endpoint", "test://endpointUri.1", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint2 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test2Endpoint", "test://endpointUri.2", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint3 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test3Endpoint", "test://endpointUri.3");
        OutboundEndpoint endpoint4 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test4endpoint", "test://endpointUri.4?synchronous=true", null, (Filter)new PayloadTypeFilter(Apple.class), null);
        OutboundEndpoint endpoint5 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test5Endpoint", "test://endpointUri.5?synchronous=true", null, (Filter)new PayloadTypeFilter(Orange.class), null);
        OutboundEndpoint endpoint6 = ListMessageSplitterTestCase.getTestOutboundEndpoint("Test6Endpoint", "test://endpointUri.6?synchronous=true");
        ListMessageSplitter asyncSplitter = new ListMessageSplitter();
        asyncSplitter.setMuleContext(muleContext);
        asyncSplitter.setDisableRoundRobin(true);
        asyncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        asyncSplitter.addEndpoint(endpoint1);
        asyncSplitter.addEndpoint(endpoint2);
        asyncSplitter.addEndpoint(endpoint3);
        ListMessageSplitter syncSplitter = new ListMessageSplitter();
        syncSplitter.setMuleContext(muleContext);
        syncSplitter.setDisableRoundRobin(true);
        syncSplitter.setFilter((Filter)new PayloadTypeFilter(List.class));
        syncSplitter.addEndpoint(endpoint4);
        syncSplitter.addEndpoint(endpoint5);
        syncSplitter.addEndpoint(endpoint6);
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(new Apple());
        payload.add(new Apple());
        payload.add(new Orange());
        payload.add(new String());
        DefaultMuleMessage message = new DefaultMuleMessage(payload, muleContext);
        ListMessageSplitterTestCase.assertTrue((boolean)asyncSplitter.isMatch((MuleMessage)message));
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint1)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(Orange.class), (Constraint)C.eq((Object)endpoint2)));
        session.expect("dispatchEvent", C.args((Constraint)new PayloadClassConstraint(String.class), (Constraint)C.eq((Object)endpoint3)));
        asyncSplitter.route((MuleMessage)message, (MuleSession)session.proxy());
        session.verify();
        message = new DefaultMuleMessage(payload, muleContext);
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("getService", (Object)ListMessageSplitterTestCase.getTestService());
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint4)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Apple.class), (Constraint)C.eq((Object)endpoint4)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(Orange.class), (Constraint)C.eq((Object)endpoint5)), (Object)message);
        session.expectAndReturn("sendEvent", C.args((Constraint)new PayloadClassConstraint(String.class), (Constraint)C.eq((Object)endpoint6)), (Object)message);
        MuleMessage result = syncSplitter.route((MuleMessage)message, (MuleSession)session.proxy());
        ListMessageSplitterTestCase.assertNotNull((Object)result);
        ListMessageSplitterTestCase.assertTrue((boolean)(result instanceof MuleMessageCollection));
        ListMessageSplitterTestCase.assertEquals((int)4, (int)((MuleMessageCollection)result).size());
        session.verify();
    }
}

