/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mule.api.transformer.DataType;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.types.CollectionDataType;
import org.mule.transformer.types.DataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypesTestCase
extends AbstractMuleTestCase {
    private List<Exception> listOfExceptions;

    public void testSimpleTypes() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.create(Exception.class);
        DataType dt2 = factory.create(Exception.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = factory.create(IOException.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = factory.create(IOException.class, "application/exception+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = factory.create(Exception.class);
        dt2 = factory.create(String.class);
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testCollectionTypes() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.create(List.class);
        DataType dt2 = factory.create(List.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = factory.create(ArrayList.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = factory.create(ArrayList.class, "application/list+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = factory.create(List.class);
        dt2 = factory.create(Set.class);
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypes() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.create(List.class, Exception.class);
        DataType dt2 = factory.create(List.class, Exception.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = factory.create(ArrayList.class, IOException.class);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt2 = factory.create(ArrayList.class, IOException.class, "application/list+java");
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt.setMimeType("application/octet-stream");
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
        dt = factory.create(List.class, Exception.class);
        dt2 = factory.create(List.class, String.class);
        DataTypesTestCase.assertFalse((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromMethodReturn() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.createFromReturnType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", String.class));
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(List.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
        DataType dt2 = factory.createFromReturnType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", String.class));
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = factory.createFromReturnType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", Integer.class));
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromMethodParam() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.createFromParameterType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", Collection.class), 0);
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(Collection.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
        DataType dt2 = factory.createFromParameterType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", Collection.class), 0);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertEquals((Object)dt, (Object)dt2);
        dt2 = factory.createFromParameterType(this.getClass().getDeclaredMethod("listOfExceptionsMethod", List.class), 0);
        DataTypesTestCase.assertTrue((boolean)dt.isCompatibleWith(dt2));
        DataTypesTestCase.assertFalse((boolean)dt.equals(dt2));
    }

    public void testGenericCollectionTypesFromField() throws Exception {
        DataTypeFactory factory = new DataTypeFactory();
        DataType dt = factory.createFromField(this.getClass().getDeclaredField("listOfExceptions"));
        DataTypesTestCase.assertTrue((boolean)(dt instanceof CollectionDataType));
        DataTypesTestCase.assertEquals(List.class, (Object)dt.getType());
        DataTypesTestCase.assertEquals(Exception.class, (Object)((CollectionDataType)dt).getItemType());
    }

    private List<Exception> listOfExceptionsMethod(String s) {
        return null;
    }

    private ArrayList<IOException> listOfExceptionsMethod(Integer i) {
        return null;
    }

    private String listOfExceptionsMethod(Collection<Exception> exceptions) {
        return null;
    }

    private Integer listOfExceptionsMethod(List<IOException> ioExceptions) {
        return null;
    }
}

