/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Orange;
import org.mule.tck.testmodels.fruit.RedApple;
import org.mule.transformer.AbstractDiscoverableTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class TransformDiscoveryTestCase
extends AbstractMuleTestCase {
    private DataTypeFactory factory = new DataTypeFactory();

    protected void doSetUp() throws Exception {
        muleContext.getRegistry().registerTransformer((Transformer)new StringToApple());
        muleContext.getRegistry().registerTransformer((Transformer)new StringToOrange());
    }

    public void testSimpleDiscovery() throws Exception {
        Transformer t = muleContext.getRegistry().lookupTransformer(this.factory.create(String.class), this.factory.create(Apple.class));
        TransformDiscoveryTestCase.assertNotNull((Object)t);
        TransformDiscoveryTestCase.assertEquals(StringToApple.class, t.getClass());
        t = muleContext.getRegistry().lookupTransformer(this.factory.create(String.class), this.factory.create(Orange.class));
        TransformDiscoveryTestCase.assertNotNull((Object)t);
        TransformDiscoveryTestCase.assertEquals(StringToOrange.class, t.getClass());
        try {
            t = muleContext.getRegistry().lookupTransformer(this.factory.create(String.class), this.factory.create(Banana.class));
            TransformDiscoveryTestCase.fail((String)"There is no transformer to go from String to Banana");
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        muleContext.getRegistry().registerTransformer((Transformer)new StringToRedApple());
        t = muleContext.getRegistry().lookupTransformer(this.factory.create(String.class), this.factory.create(RedApple.class));
        TransformDiscoveryTestCase.assertNotNull((Object)t);
        TransformDiscoveryTestCase.assertEquals(StringToRedApple.class, t.getClass());
    }

    protected class StringToOrange
    extends AbstractDiscoverableTransformer {
        public StringToOrange() {
            this.setReturnClass(Orange.class);
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return new Orange();
        }
    }

    protected class StringToRedApple
    extends AbstractDiscoverableTransformer {
        public StringToRedApple() {
            this.setReturnClass(RedApple.class);
            this.setPriorityWeighting(10);
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return new RedApple();
        }
    }

    protected class StringToApple
    extends AbstractDiscoverableTransformer {
        public StringToApple() {
            this.setReturnClass(Apple.class);
        }

        protected Object doTransform(Object src, String encoding) throws TransformerException {
            return new Apple();
        }
    }
}

