/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;
import org.mule.util.SystemUtils;

public class CollectionUtilsTestCase
extends AbstractMuleTestCase {
    public void testToArrayOfComponentTypeNullCollection() {
        CollectionUtilsTestCase.assertNull((Object)CollectionUtils.toArrayOfComponentType(null, String.class));
    }

    public void testToArrayOfComponentTypeNullType() {
        try {
            CollectionUtils.toArrayOfComponentType((Collection)Collections.EMPTY_LIST, null);
            CollectionUtilsTestCase.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToArrayOfComponentTypeEmptyCollection() {
        CollectionUtilsTestCase.assertTrue((boolean)Arrays.equals(new String[0], CollectionUtils.toArrayOfComponentType((Collection)Collections.EMPTY_LIST, String.class)));
    }

    public void testToArrayOfComponentTypeWrongElement() {
        try {
            CollectionUtils.toArrayOfComponentType(Collections.singleton("foo"), Integer.class);
            CollectionUtilsTestCase.fail((String)"should have thrown ArrayStoreException");
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
    }

    public void testToArrayOfComponentTypeOK() {
        Object[] objects = new String[]{"foo", "bar", "baz"};
        CollectionUtilsTestCase.assertTrue((boolean)Arrays.equals(objects, CollectionUtils.toArrayOfComponentType(Arrays.asList(objects), String.class)));
    }

    public void testToStringNull() throws Exception {
        Collection c = null;
        CollectionUtilsTestCase.assertEquals((String)"[]", (String)CollectionUtils.toString(c, (boolean)false));
        CollectionUtilsTestCase.assertEquals((String)"[]", (String)CollectionUtils.toString(c, (boolean)true));
    }

    public void testToStringEmpty() throws Exception {
        ArrayList c = new ArrayList();
        CollectionUtilsTestCase.assertEquals((String)"[]", (String)CollectionUtils.toString(c, (boolean)false));
        CollectionUtilsTestCase.assertEquals((String)"[]", (String)CollectionUtils.toString(c, (boolean)true));
    }

    public void testToStringSingleElement() throws Exception {
        List<String> c = Arrays.asList("foo");
        CollectionUtilsTestCase.assertEquals((String)"[foo]", (String)CollectionUtils.toString(c, (boolean)false));
        CollectionUtilsTestCase.assertEquals((String)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + "]"), (String)CollectionUtils.toString(c, (boolean)true));
    }

    public void testToStringMultipleElements() throws Exception {
        List<Serializable> c = Arrays.asList("foo", this.getClass());
        CollectionUtilsTestCase.assertEquals((String)("[foo, " + this.getClass().getName() + "]"), (String)CollectionUtils.toString(c, (boolean)false));
        CollectionUtilsTestCase.assertEquals((String)("[" + SystemUtils.LINE_SEPARATOR + "foo" + SystemUtils.LINE_SEPARATOR + this.getClass().getName() + SystemUtils.LINE_SEPARATOR + "]"), (String)CollectionUtils.toString(c, (boolean)true));
    }

    public void testToStringTooManyElements() {
        ArrayList<Integer> test = new ArrayList<Integer>(100);
        for (int i = 0; i < 100; ++i) {
            test.add(new Integer(i));
        }
        String result = CollectionUtils.toString(test, (int)10);
        CollectionUtilsTestCase.assertTrue((boolean)result.endsWith("[..]]"));
        CollectionUtilsTestCase.assertEquals((int)9, (int)StringUtils.countMatches((String)result, (String)","));
    }
}

