/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.store.AbstractMonitoredObjectStore;

public class MonitoredObjectStoreTestCase
extends AbstractMuleTestCase {
    private static final int EXPIRATION_INTERVAL = 500;

    public void testShutdownWithHangingExpireThread() throws Exception {
        ExpiringStore store = this.createExpiringStore();
        Thread.sleep(1000L);
        store.dispose();
        MonitoredObjectStoreTestCase.assertTrue((boolean)store.expireStarted);
        MonitoredObjectStoreTestCase.assertFalse((boolean)store.expireFinished);
    }

    private ExpiringStore createExpiringStore() throws InitialisationException {
        ExpiringStore store = new ExpiringStore();
        store.setExpirationInterval(500);
        store.initialise();
        return store;
    }

    private static class ExpiringStore
    extends AbstractMonitoredObjectStore {
        protected boolean expireStarted = false;
        protected boolean expireFinished = false;

        private ExpiringStore() {
        }

        protected void expire() {
            try {
                this.expireStarted = true;
                Thread.sleep(5000L);
                this.expireFinished = true;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("expire was interrupted", e);
            }
        }

        public boolean containsObject(String id) throws Exception {
            return false;
        }

        public boolean removeObject(String id) throws Exception {
            return false;
        }

        public Object retrieveObject(String id) throws Exception {
            return null;
        }

        public boolean storeObject(String id, Object item) throws Exception {
            return false;
        }
    }
}

