/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.Map;
import java.util.TreeMap;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import org.mule.api.MuleException;
import org.mule.transport.email.MailMessageAdapter;
import org.mule.transport.email.MailUtils;

public class EagerMailMessageAdapter
extends MailMessageAdapter {
    private static final long serialVersionUID = -6013198455030918360L;
    public static final String ATTACHMENT_HEADERS_PROPERTY_POSTFIX = "Headers";
    private Object payload;

    public EagerMailMessageAdapter(Object object) throws MuleException {
        super(object);
    }

    protected void handleMessage(Message message) throws Exception {
        this.payload = message.getContent();
        if (this.payload instanceof Multipart) {
            TreeMap attachments = new TreeMap();
            MailUtils.getAttachments((Multipart)this.payload, attachments);
            logger.debug((Object)"Received Multipart message. Adding attachments");
            for (Map.Entry entry : attachments.entrySet()) {
                Part part = (Part)entry.getValue();
                String name = entry.getKey().toString();
                this.addAttachment(name, part.getDataHandler());
                this.addAttachmentHeaders(name, part);
            }
        }
    }

    public Object getPayload() {
        return this.payload;
    }
}

