/*
 * $Id: MuleContextNotification.java 16510 2010-01-18 22:02:21Z aperepel $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.context.notification;

import org.mule.api.MuleContext;
import org.mule.api.context.notification.BlockingServerEvent;
import org.mule.api.context.notification.ServerNotification;

/**
 * <code>MuleContextNotification</code> is fired when an event such as the mule
 * context starting occurs. The payload of this event will always be a reference to
 * the muleContext.
 */
public class MuleContextNotification extends ServerNotification implements BlockingServerEvent
{
    /**
     * Serial version
     */
    private static final long serialVersionUID = -3246036188011581121L;
    
    public static final int CONTEXT_INITIALISING = CONTEXT_EVENT_ACTION_START_RANGE + 1;
    public static final int CONTEXT_INITIALISED = CONTEXT_EVENT_ACTION_START_RANGE + 2;
    public static final int CONTEXT_STARTING = CONTEXT_EVENT_ACTION_START_RANGE + 3;
    public static final int CONTEXT_STARTED = CONTEXT_EVENT_ACTION_START_RANGE + 4;
    public static final int CONTEXT_STOPPING = CONTEXT_EVENT_ACTION_START_RANGE + 5;
    public static final int CONTEXT_STOPPED = CONTEXT_EVENT_ACTION_START_RANGE + 6;
    public static final int CONTEXT_DISPOSING = CONTEXT_EVENT_ACTION_START_RANGE + 7;
    public static final int CONTEXT_DISPOSED = CONTEXT_EVENT_ACTION_START_RANGE + 8;
    
    static {
        registerAction("mule context initialising", CONTEXT_INITIALISING);
        registerAction("mule context initialised", CONTEXT_INITIALISED);
        registerAction("mule context starting", CONTEXT_STARTING);
        registerAction("mule context started", CONTEXT_STARTED);
        registerAction("mule context stopping", CONTEXT_STOPPING);
        registerAction("mule context stopped", CONTEXT_STOPPED);
        registerAction("mule context disposing", CONTEXT_DISPOSING);
        registerAction("mule context disposed", CONTEXT_DISPOSED);
    }

    private String clusterId;
    private String domain;


    public MuleContextNotification(MuleContext context, String action)
    {
        this(context, getActionId(action));
    }

    public MuleContextNotification(MuleContext context, int action)
    {
        super(generateId(context), action);
        resourceIdentifier = getSource().toString();
        this.clusterId = context.getConfiguration().getClusterId();
        this.domain = context.getConfiguration().getDomainId();
    }

    public String getClusterId()
    {
        return clusterId;
    }

    public String getDomain()
    {
        return domain;
    }

    @Override
    protected String getPayloadToString()
    {
        return ((MuleContext) source).getConfiguration().getId();
    }

    @Override
    public String toString()
    {
        return EVENT_NAME + "{" + "action=" + getActionName(action) + ", resourceId=" + resourceIdentifier
                + ", timestamp=" + timestamp + "}";
    }
    
}
