/*
 * $Id: QueueManager.java 11968 2008-06-06 04:06:18Z dfeist $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSource, Inc.  All rights reserved.  http://www.mulesource.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.util.queue;

import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;

/**
 * A Queue manager is responsible for manageing one or more Queue resources and
 * providing common support fot transactions and persistence
 */
public interface QueueManager extends Startable, Stoppable
{

    QueueSession getQueueSession();

    void setDefaultQueueConfiguration(QueueConfiguration config);

    void setQueueConfiguration(String queueName, QueueConfiguration config);

    /**
     * @return Returns the persistenceStrategy.
     */
    QueuePersistenceStrategy getPersistenceStrategy();

    /**
     * @param persistenceStrategy The persistenceStrategy to set.
     */
    void setPersistenceStrategy(QueuePersistenceStrategy persistenceStrategy);

    QueuePersistenceStrategy getMemoryPersistenceStrategy();

    void setMemoryPersistenceStrategy(QueuePersistenceStrategy memoryPersistenceStrategy);

}
