/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.transformer.jaxb;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.registry.RegistrationException;
import org.mule.api.registry.ResolverException;
import org.mule.api.registry.TransformerResolver;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.transformer.jaxb.JAXBContextResolver;
import org.mule.module.xml.transformer.jaxb.JAXBMarshallerTransformer;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.transformer.simple.ObjectToString;
import org.mule.util.annotation.AnnotationUtils;

public class JAXBTransformerResolver
implements TransformerResolver,
MuleContextAware,
Disposable {
    public static final String[] ignoredPackages = new String[]{"java.,javax.,org.w3c.,org.mule.transport., org.mule.module."};
    protected final transient Log logger = LogFactory.getLog(JAXBTransformerResolver.class);
    private MuleContext muleContext;
    private Map<String, Transformer> transformerCache = new ConcurrentHashMap<String, Transformer>();
    private JAXBContextResolver resolver;

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public Transformer resolve(DataType source, DataType result) throws ResolverException {
        Transformer t = this.transformerCache.get(source.toString() + result.toString());
        if (t != null) {
            return t;
        }
        try {
            List<Transformer> ts;
            JAXBContext jaxb = (JAXBContext)this.getContextResolver().resolve(JAXBContext.class, source, result, this.muleContext);
            if (jaxb == null) {
                return null;
            }
            boolean marshal = false;
            Class<?> annotatedType = null;
            if (this.getContextResolver().getMatchingClasses().contains(result.getType())) {
                annotatedType = result.getType();
                marshal = false;
            } else if (this.getContextResolver().getMatchingClasses().contains(source.getType())) {
                annotatedType = source.getType();
                marshal = true;
            }
            if (annotatedType == null) {
                annotatedType = result.getType();
                boolean isJAXB = this.hasJaxbAnnotations(annotatedType);
                if (!isJAXB) {
                    marshal = true;
                    annotatedType = source.getType();
                    isJAXB = this.hasJaxbAnnotations(annotatedType);
                }
                if (!isJAXB) {
                    return null;
                }
            }
            t = (ts = this.muleContext.getRegistry().lookupTransformers(source, result)).size() == 1 && !(ts.get(0) instanceof ObjectToString) ? ts.get(0) : (marshal ? new JAXBMarshallerTransformer(jaxb, result) : new JAXBUnmarshallerTransformer(jaxb, result));
            this.transformerCache.put(source.toString() + result.toString(), t);
            return t;
        }
        catch (Exception e) {
            throw new ResolverException(CoreMessages.createStaticMessage("Failed to unmarshal"), (Throwable)e);
        }
    }

    public void transformerChange(Transformer transformer, TransformerResolver.RegistryAction registryAction) {
    }

    public void dispose() {
        this.transformerCache.clear();
    }

    protected JAXBContextResolver getContextResolver() throws RegistrationException {
        if (this.resolver == null) {
            this.resolver = this.muleContext.getRegistry().lookupObject(JAXBContextResolver.class);
        }
        return this.resolver;
    }

    protected boolean hasJaxbAnnotations(Class annotatedType) {
        String p = annotatedType.getPackage().getName();
        for (int i = 0; i < ignoredPackages.length; ++i) {
            if (!p.startsWith(ignoredPackages[i])) continue;
            return false;
        }
        try {
            return AnnotationUtils.hasAnnotationWithPackage("javax.xml.bind.annotation", annotatedType);
        }
        catch (IOException e) {
            this.logger.warn((Object)("Failed to scan class for Jaxb annotations: " + annotatedType), (Throwable)e);
            return false;
        }
    }
}

