/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectValueExpression
extends ValueExpression {
    private static final long serialVersionUID = 1L;
    private final Object object;
    private final Class<?> type;

    public ObjectValueExpression(Object object, Class<?> clazz) {
        this.object = object;
        this.type = clazz;
        if (clazz == null) {
            throw new NullPointerException(LocalMessages.get("error.value.notype", new Object[0]));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ObjectValueExpression objectValueExpression = (ObjectValueExpression)object;
            if (this.type != objectValueExpression.type) {
                return false;
            }
            return this.object == objectValueExpression.object || this.object != null && this.object.equals(objectValueExpression.object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.object == null ? 0 : this.object.hashCode();
    }

    @Override
    public Object getValue(ELContext eLContext) {
        return TypeConversions.coerceToType(this.object, this.type);
    }

    @Override
    public String getExpressionString() {
        return null;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getType(ELContext eLContext) {
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext eLContext) {
        return true;
    }

    @Override
    public void setValue(ELContext eLContext, Object object) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", new Object[0]));
    }

    public String toString() {
        return "ValueExpression(" + this.object + ")";
    }

    @Override
    public Class<?> getExpectedType() {
        return this.type;
    }
}

