/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.Credentials;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.simple.ByteArrayToObject;
import org.mule.transformer.simple.SerializableToByteArray;

public class MuleEventTestCase
extends AbstractMuleTestCase {
    public void testNoPasswordNoNullPointerException() throws Exception {
        OutboundEndpoint endpoint = MuleEventTestCase.getTestOutboundEndpoint("AuthTest", "test://john.doe@xyz.fr");
        MuleEvent event = MuleEventTestCase.getTestEvent(new Object(), (ImmutableEndpoint)endpoint);
        Credentials credentials = event.getCredentials();
        MuleEventTestCase.assertNull((String)"Credentials must not be created for endpoints without a password.", (Object)credentials);
    }

    public void testEventSerialization() throws Exception {
        TestEventTransformer trans1 = new TestEventTransformer();
        trans1.setName("OptimusPrime");
        TestEventTransformer trans2 = new TestEventTransformer();
        trans2.setName("Bumblebee");
        ArrayList<TestEventTransformer> transformers = new ArrayList<TestEventTransformer>();
        transformers.add(trans1);
        transformers.add(trans2);
        OutboundEndpoint endpoint = MuleEventTestCase.getTestOutboundEndpoint("Test", null, transformers, (Filter)new PayloadTypeFilter(Object.class), null);
        MuleEvent event = RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent((Object)"payload", (ImmutableEndpoint)endpoint));
        Serializable serialized = (Serializable)new SerializableToByteArray().transform((Object)event);
        MuleEventTestCase.assertNotNull((Object)serialized);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        MuleEventTestCase.assertNotNull((Object)deserialized);
        MuleEventTestCase.assertNotNull((Object)deserialized.getMuleContext());
        MuleEventTestCase.assertNotNull((Object)deserialized.getSession());
        MuleEventTestCase.assertEquals((String)event.getSession().getId(), (String)deserialized.getSession().getId());
        MuleEventTestCase.assertNotNull((Object)deserialized.getSession().getFlowConstruct());
        MuleEventTestCase.assertEquals((Object)event.getSession().getFlowConstruct(), (Object)deserialized.getSession().getFlowConstruct());
        MuleEventTestCase.assertSame((Object)event.getSession().getFlowConstruct(), (Object)deserialized.getSession().getFlowConstruct());
        MuleEventTestCase.assertNotNull((Object)deserialized.getEndpoint());
        MuleEventTestCase.assertEquals((Object)endpoint, (Object)deserialized.getEndpoint());
        List deserializedTransformers = deserialized.getEndpoint().getTransformers();
        MuleEventTestCase.assertEquals((int)2, (int)deserializedTransformers.size());
        MuleEventTestCase.assertEquals((String)trans1.getName(), (String)((Transformer)deserializedTransformers.get(0)).getName());
        MuleEventTestCase.assertEquals((String)trans2.getName(), (String)((Transformer)deserializedTransformers.get(1)).getName());
        MuleEventTestCase.assertEquals(PayloadTypeFilter.class, deserialized.getEndpoint().getFilter().getClass());
    }

    public void testEventSerializationRestart() throws Exception {
        MuleEvent event = this.createEventToSerialize();
        muleContext.start();
        List transformers = event.getEndpoint().getTransformers();
        ImmutableEndpoint endpoint = event.getEndpoint();
        Serializable serialized = (Serializable)new SerializableToByteArray().transform((Object)event);
        MuleEventTestCase.assertNotNull((Object)serialized);
        muleContext.dispose();
        muleContext = this.createMuleContext();
        muleContext.start();
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        this.createAndRegisterTransformersEndpointBuilderService();
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        MuleEventTestCase.assertNotNull((Object)deserialized);
        MuleEventTestCase.assertNotNull((Object)deserialized.getMuleContext());
        MuleEventTestCase.assertNotNull((Object)deserialized.getSession());
        MuleEventTestCase.assertEquals((String)event.getSession().getId(), (String)deserialized.getSession().getId());
        MuleEventTestCase.assertNotNull((Object)deserialized.getSession().getFlowConstruct());
        Service service = (Service)event.getSession().getFlowConstruct();
        Service deserializedService = (Service)deserialized.getSession().getFlowConstruct();
        MuleEventTestCase.assertEquals((String)service.getName(), (String)deserializedService.getName());
        MuleEventTestCase.assertEquals((String)service.getInitialState(), (String)deserializedService.getInitialState());
        MuleEventTestCase.assertEquals(service.getExceptionListener().getClass(), deserializedService.getExceptionListener().getClass());
        MuleEventTestCase.assertEquals(service.getComponent().getClass(), deserializedService.getComponent().getClass());
        MuleEventTestCase.assertNotNull((Object)deserialized.getEndpoint());
        MuleEventTestCase.assertEquals((String)endpoint.getEncoding(), (String)deserialized.getEndpoint().getEncoding());
        MuleEventTestCase.assertEquals((String)endpoint.getEndpointBuilderName(), (String)deserialized.getEndpoint().getEndpointBuilderName());
        MuleEventTestCase.assertEquals((Object)endpoint.getEndpointURI(), (Object)deserialized.getEndpoint().getEndpointURI());
        MuleEventTestCase.assertEquals((String)endpoint.getProtocol(), (String)deserialized.getEndpoint().getProtocol());
        MuleEventTestCase.assertEquals((int)endpoint.getResponseTimeout(), (int)deserialized.getEndpoint().getResponseTimeout());
        MuleEventTestCase.assertEquals(endpoint.getConnector().getClass(), deserialized.getEndpoint().getConnector().getClass());
        List deserializedTransformers = deserialized.getEndpoint().getTransformers();
        MuleEventTestCase.assertEquals((int)2, (int)deserializedTransformers.size());
        MuleEventTestCase.assertEquals((String)((Transformer)transformers.get(0)).getName(), (String)((Transformer)deserializedTransformers.get(0)).getName());
        MuleEventTestCase.assertEquals((String)((Transformer)transformers.get(1)).getName(), (String)((Transformer)deserializedTransformers.get(1)).getName());
        MuleEventTestCase.assertEquals(PayloadTypeFilter.class, deserialized.getEndpoint().getFilter().getClass());
    }

    public void testMuleCredentialsSerialization() throws Exception {
        String username = "mule";
        String password = "rulez";
        String url = "test://" + username + ":" + password + "@localhost";
        OutboundEndpoint endpoint = MuleEventTestCase.getTestOutboundEndpoint("Test", url);
        ByteArrayToObject trans = new ByteArrayToObject();
        trans.setMuleContext(muleContext);
        MuleEvent event = RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent((Object)"payload", (ImmutableEndpoint)endpoint));
        Serializable serialized = (Serializable)new SerializableToByteArray().transform((Object)event);
        MuleEventTestCase.assertNotNull((Object)serialized);
        MuleEvent deserialized = (MuleEvent)trans.transform((Object)serialized);
        MuleEventTestCase.assertNotNull((Object)deserialized);
        Credentials credentials = deserialized.getCredentials();
        MuleEventTestCase.assertNotNull((Object)credentials);
        MuleEventTestCase.assertEquals((String)username, (String)credentials.getUsername());
        MuleEventTestCase.assertTrue((boolean)Arrays.equals(password.toCharArray(), credentials.getPassword()));
    }

    private MuleEvent createEventToSerialize() throws Exception {
        this.createAndRegisterTransformersEndpointBuilderService();
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(muleContext.getRegistry().lookupEndpointBuilder("epBuilderTest"));
        Service service = muleContext.getRegistry().lookupService("appleService");
        return RequestContext.setEvent((MuleEvent)MuleEventTestCase.getTestEvent("payload", service, (ImmutableEndpoint)endpoint));
    }

    private void createAndRegisterTransformersEndpointBuilderService() throws Exception {
        TestEventTransformer trans1 = new TestEventTransformer();
        trans1.setName("OptimusPrime");
        muleContext.getRegistry().registerTransformer((Transformer)trans1);
        TestEventTransformer trans2 = new TestEventTransformer();
        trans2.setName("Bumblebee");
        muleContext.getRegistry().registerTransformer((Transformer)trans2);
        ArrayList<TestEventTransformer> transformers = new ArrayList<TestEventTransformer>();
        transformers.add(trans1);
        transformers.add(trans2);
        PayloadTypeFilter filter = new PayloadTypeFilter(Object.class);
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://serializationTest", muleContext);
        endpointBuilder.setTransformers(transformers);
        endpointBuilder.setName("epBuilderTest");
        endpointBuilder.addMessageProcessor((MessageProcessor)new MessageFilter((Filter)filter));
        muleContext.getRegistry().registerEndpointBuilder("epBuilderTest", (EndpointBuilder)endpointBuilder);
        MuleEventTestCase.getTestService();
    }

    private static class TestEventTransformer
    extends AbstractTransformer {
        private TestEventTransformer() {
        }

        public Object doTransform(Object src, String encoding) throws TransformerException {
            return "Transformed Test Data";
        }
    }
}

