/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.Comparator;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.service.Service;
import org.mule.routing.EventGroup;
import org.mule.routing.Resequencer;
import org.mule.routing.correlation.CorrelationSequenceComparator;
import org.mule.routing.correlation.EventCorrelatorCallback;
import org.mule.routing.correlation.ResequenceMessagesCorrelatorCallback;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class ResequencerTestCase
extends AbstractMuleTestCase {
    public ResequencerTestCase() {
        this.setStartContext(true);
    }

    public void testMessageResequencer() throws Exception {
        MuleSession session = ResequencerTestCase.getTestSession(ResequencerTestCase.getTestService(), muleContext);
        Service testService = ResequencerTestCase.getTestService("test", Apple.class);
        ResequencerTestCase.assertNotNull((Object)testService);
        TestEventResequencer router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        DefaultMuleMessage message1 = new DefaultMuleMessage((Object)"test event A", muleContext);
        DefaultMuleMessage message2 = new DefaultMuleMessage((Object)"test event B", muleContext);
        DefaultMuleMessage message3 = new DefaultMuleMessage((Object)"test event C", muleContext);
        String correlationId = message1.getUniqueId();
        message1.setCorrelationId(correlationId);
        message2.setCorrelationId(correlationId);
        message3.setCorrelationId(correlationId);
        OutboundEndpoint endpoint = MuleTestUtils.getTestOutboundEndpoint(MessageExchangePattern.ONE_WAY, muleContext);
        DefaultMuleEvent event1 = new DefaultMuleEvent((MuleMessage)message1, (ImmutableEndpoint)endpoint, session);
        DefaultMuleEvent event2 = new DefaultMuleEvent((MuleMessage)message2, (ImmutableEndpoint)endpoint, session);
        DefaultMuleEvent event3 = new DefaultMuleEvent((MuleMessage)message3, (ImmutableEndpoint)endpoint, session);
        ResequencerTestCase.assertNull((Object)router.process((MuleEvent)event2));
        ResequencerTestCase.assertNull((Object)router.process((MuleEvent)event3));
        MuleEvent resultEvent = router.process((MuleEvent)event1);
        ResequencerTestCase.assertNotNull((Object)resultEvent);
        MuleMessage resultMessage = resultEvent.getMessage();
        ResequencerTestCase.assertNotNull((Object)resultMessage);
        ResequencerTestCase.assertEquals((String)"test event A", (String)resultMessage.getPayloadAsString());
        router = new TestEventResequencer(3);
        router.setMuleContext(muleContext);
        router.setEventComparator(new EventPayloadComparator());
        router.setFlowConstruct((FlowConstruct)testService);
        router.initialise();
        ResequencerTestCase.assertNull((Object)router.process((MuleEvent)event2));
        ResequencerTestCase.assertNull((Object)router.process((MuleEvent)event3));
        resultEvent = router.process((MuleEvent)event1);
        ResequencerTestCase.assertNotNull((Object)resultEvent);
        resultMessage = resultEvent.getMessage();
        ResequencerTestCase.assertNotNull((Object)resultMessage);
        ResequencerTestCase.assertEquals((String)"test event C", (String)resultMessage.getPayloadAsString());
    }

    public static class EventPayloadComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            try {
                return ((MuleEvent)o1).getMessageAsString().compareTo(((MuleEvent)o2).getMessageAsString());
            }
            catch (MuleException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public static class TestEventResequencer
    extends Resequencer {
        private int eventCount = 0;
        private int eventthreshold = 1;

        public TestEventResequencer(int eventthreshold) {
            this.eventthreshold = eventthreshold;
            this.setEventComparator((Comparator)new CorrelationSequenceComparator());
        }

        protected EventCorrelatorCallback getCorrelatorCallback(MuleContext muleContext) {
            return new ResequenceMessagesCorrelatorCallback(this.getEventComparator(), muleContext){

                public boolean shouldAggregateEvents(EventGroup events) {
                    TestEventResequencer.this.eventCount++;
                    if (TestEventResequencer.this.eventCount == TestEventResequencer.this.eventthreshold) {
                        TestEventResequencer.this.eventCount = 0;
                        return true;
                    }
                    return false;
                }
            };
        }
    }
}

