/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouterCatchAllStrategy;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.LoggingCatchAllStrategy;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.outbound.ChainingRouter;
import org.mule.routing.outbound.DefaultOutboundRouterCollection;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.testmodels.fruit.Apple;

public class ChainingRouterTestCase
extends AbstractMuleTestCase {
    private Mock session;
    private ChainingRouter router;
    private List<OutboundEndpoint> endpoints;
    private Mock mockendpoint1;
    private Mock mockendpoint2;
    private Mock mockendpoint3;

    public ChainingRouterTestCase() {
        this.setStartContext(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.session = MuleTestUtils.getMockSession();
        this.router = new ChainingRouter();
        DefaultOutboundRouterCollection messageRouter = new DefaultOutboundRouterCollection();
        messageRouter.setCatchAllStrategy((OutboundRouterCatchAllStrategy)new LoggingCatchAllStrategy());
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test?exchangePattern=request-response");
        ChainingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test?exchangePattern=request-response");
        ChainingRouterTestCase.assertNotNull((Object)endpoint2);
        this.mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        this.mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        PayloadTypeFilter filter = new PayloadTypeFilter(String.class);
        this.router.setFilter((Filter)filter);
        this.endpoints = new ArrayList<OutboundEndpoint>();
        this.endpoints.add((OutboundEndpoint)this.mockendpoint1.proxy());
        this.endpoints.add((OutboundEndpoint)this.mockendpoint2.proxy());
        this.router.setRoutes(new ArrayList<OutboundEndpoint>(this.endpoints));
        ChainingRouterTestCase.assertEquals((Object)filter, (Object)this.router.getFilter());
        this.session.matchAndReturn("getFlowConstruct", (Object)ChainingRouterTestCase.getTestService("TEST", Apple.class));
    }

    public void testChainingOutboundRouterSynchronous() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        this.mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        this.mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        ChainingRouterTestCase.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        ChainingRouterTestCase.assertEquals((Object)message, (Object)result.getMessage());
        this.mockendpoint1.verify();
        this.mockendpoint2.verify();
    }

    public void testChainingOutboundRouterSynchronousWithTemplate() throws Exception {
        OutboundEndpoint endpoint3 = ChainingRouterTestCase.getTestOutboundEndpoint("Test3Provider", "test://foo?[barValue]&exchangePattern=request-response");
        ChainingRouterTestCase.assertNotNull((Object)endpoint3);
        this.mockendpoint3 = RouterTestUtils.getMockEndpoint(endpoint3);
        this.router.addRoute((MessageProcessor)((OutboundEndpoint)this.mockendpoint3.proxy()));
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("barValue", "bar");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", m, muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        ImmutableEndpoint ep = (ImmutableEndpoint)this.router.getRoute(2, (MuleMessage)message);
        ChainingRouterTestCase.assertEquals((String)"test://foo?bar&exchangePattern=request-response", (String)ep.getEndpointURI().toString());
        this.mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        this.mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        this.mockendpoint3.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        ChainingRouterTestCase.assertNotNull((String)"This is a sync call, we need a result returned.", (Object)result);
        ChainingRouterTestCase.assertEquals((Object)message, (Object)result.getMessage());
        this.mockendpoint1.verify();
        this.mockendpoint2.verify();
        this.mockendpoint3.verify();
    }

    public void testChainingOutboundRouterAsynchronous() throws Exception {
        OutboundEndpoint endpoint1 = ChainingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test");
        ChainingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = ChainingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test");
        ChainingRouterTestCase.assertNotNull((Object)endpoint2);
        Mock mep1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mep2 = RouterTestUtils.getMockEndpoint(endpoint2);
        this.endpoints.clear();
        this.endpoints.add((OutboundEndpoint)mep1.proxy());
        this.endpoints.add((OutboundEndpoint)mep2.proxy());
        this.router.setRoutes(new ArrayList<OutboundEndpoint>(this.endpoints));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        ChainingRouterTestCase.assertTrue((boolean)this.router.isMatch((MuleMessage)message));
        message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        mep1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mep2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), null);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        ChainingRouterTestCase.assertNull((String)"Async call shouldn't return any result.", (Object)result);
        mep1.verify();
        mep2.verify();
    }

    public void testBrokenChain() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test event", muleContext);
        OutboundEndpoint endpoint1 = this.endpoints.get(0);
        this.mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), null);
        MuleEvent result = this.router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)this.session.proxy()));
        this.mockendpoint1.verify();
        ChainingRouterTestCase.assertNull((Object)result);
    }
}

