/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer;

import java.util.Collections;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.TransformerChain;
import org.mule.transformer.types.DataTypeFactory;

public class TransformerChainingTestCase
extends AbstractMuleTestCase {
    public void testSingleChainedTransformer() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        TransformerChainingTestCase.assertNotNull((Object)transformedMessage);
        TransformerChainingTestCase.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    public void testTwoChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer});
        message.applyTransformers(null, Collections.singletonList(messageTransformer));
        Object transformedMessage = message.getPayload();
        TransformerChainingTestCase.assertNotNull((Object)transformedMessage);
        TransformerChainingTestCase.assertEquals((Object)new Integer(2), (Object)transformedMessage);
    }

    public void testThreeChainedTransformers() throws Exception {
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, validTransformer, validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        TransformerChainingTestCase.assertNotNull((Object)transformedMessage);
        TransformerChainingTestCase.assertEquals((Object)new Integer(3), (Object)transformedMessage);
    }

    public void testIgnoreBadInputDoesNotBreakChainWithTransformationOrderInvalidValid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        TransformerChainingTestCase.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(true);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        TransformerChainingTestCase.assertNotNull((Object)transformedMessage);
        TransformerChainingTestCase.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    public void testIgnoreBadInputBreaksChainWithTransformationOrderInvalidValid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        TransformerChainingTestCase.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{invalidTransformer, validTransformer});
        try {
            message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
            TransformerChainingTestCase.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException tfe) {
            // empty catch block
        }
    }

    public void testIgnoreBadInputDoesNotBreakChainWithTransformationOrderValidInvalid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        TransformerChainingTestCase.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(true);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, invalidTransformer});
        message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
        Object transformedMessage = message.getPayload();
        TransformerChainingTestCase.assertNotNull((Object)transformedMessage);
        TransformerChainingTestCase.assertEquals((Object)new Integer(1), (Object)transformedMessage);
    }

    public void testIgnoreBadInputBreaksChainWithTransformationOrderValidInvalid() throws Exception {
        AbstractTransformer invalidTransformer = (AbstractTransformer)this.getInvalidTransformer();
        TransformerChainingTestCase.assertNotNull((Object)invalidTransformer);
        invalidTransformer.setIgnoreBadInput(false);
        AbstractTransformer validTransformer = (AbstractTransformer)this.getIncreaseByOneTransformer();
        TransformerChainingTestCase.assertNotNull((Object)validTransformer);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Integer(0), muleContext);
        TransformerChain messageTransformer = new TransformerChain(new Transformer[]{validTransformer, invalidTransformer});
        try {
            message.applyTransformers((MuleEvent)null, new Transformer[]{messageTransformer});
            TransformerChainingTestCase.fail((String)"Transformer chain is expected to fail because of invalid transformer within chain.");
        }
        catch (MuleException tfe) {
            TransformerChainingTestCase.assertNotNull((Object)((Object)tfe));
        }
    }

    private Transformer getInvalidTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, String encoding) throws TransformerException {
                throw new RuntimeException("This transformer must not perform any transformations.");
            }
        };
        transformer.registerSourceType(this.getClass());
        return transformer;
    }

    private Transformer getIncreaseByOneTransformer() throws Exception {
        AbstractTransformer transformer = new AbstractTransformer(){

            protected Object doTransform(Object src, String encoding) throws TransformerException {
                return new Integer((Integer)src + 1);
            }
        };
        transformer.registerSourceType(Integer.class);
        transformer.setReturnDataType(DataTypeFactory.create(Integer.class));
        return transformer;
    }
}

