/*
 * Decompiled with CFR 0.152.
 */
package org.mule.construct;

import java.lang.reflect.Method;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.component.Component;
import org.mule.api.component.JavaComponent;
import org.mule.api.construct.FlowConstructInvalidException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.source.MessageSource;
import org.mule.config.i18n.MessageFactory;
import org.mule.construct.AbstractFlowConstruct;
import org.mule.construct.processor.FlowConstructStatisticsMessageObserver;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.processor.builder.InterceptingChainMessageProcessorBuilder;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleService
extends AbstractFlowConstruct {
    private final Component component;
    private final Type type;

    public SimpleService(String name, MuleContext muleContext, MessageSource messageSource, Component component, Type type) throws MuleException {
        super(name, muleContext);
        if (messageSource == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("messageSource can't be null on: " + this.toString()));
        }
        if (component == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("component can't be null on: " + this.toString()));
        }
        if (type == null) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("type can't be null on: " + this.toString()));
        }
        this.messageSource = messageSource;
        this.component = component;
        this.type = type;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    protected void configureMessageProcessors(InterceptingChainMessageProcessorBuilder builder) {
        builder.chain(new LoggingInterceptor());
        builder.chain(new FlowConstructStatisticsMessageObserver());
        if (this.type != Type.DEFAULT) {
            this.configureComponentMessageProcessor(builder);
        }
        builder.chain(this.component);
    }

    @Override
    protected void validateConstruct() throws FlowConstructInvalidException {
        super.validateConstruct();
        if (this.messageSource instanceof InboundEndpoint && !((InboundEndpoint)this.messageSource).getExchangePattern().equals((Object)MessageExchangePattern.REQUEST_RESPONSE)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("SimpleService only works with a request-response inbound endpoint."), this);
        }
        if (this.type == Type.JAX_WS && !(this.component instanceof JavaComponent)) {
            throw new FlowConstructInvalidException(MessageFactory.createStaticMessage("SimpleService can only expose instances of JavaComponent as web services."), this);
        }
    }

    private void configureComponentMessageProcessor(InterceptingChainMessageProcessorBuilder builder) {
        Class<?> componentClass = this.getComponentClass();
        if (this.type == Type.JAX_WS) {
            builder.chain(this.newWebServiceMessageProcessor(componentClass));
        }
    }

    private Class<?> getComponentClass() {
        if (this.component instanceof JavaComponent) {
            return ((JavaComponent)this.component).getObjectFactory().getObjectClass();
        }
        return this.component.getClass();
    }

    private MessageProcessor newWebServiceMessageProcessor(Class<?> componentClass) {
        try {
            MessageProcessorBuilder wsmpb = (MessageProcessorBuilder)ClassUtils.instanciateClass("org.mule.module.cxf.builder.WebServiceMessageProcessorBuilder", new Object[0]);
            Method setServiceClassMethod = ClassUtils.getMethod(wsmpb.getClass(), "setServiceClass", new Class[]{Class.class});
            setServiceClassMethod.invoke((Object)wsmpb, componentClass);
            Method setFrontendMethod = ClassUtils.getMethod(wsmpb.getClass(), "setFrontend", new Class[]{String.class});
            setFrontendMethod.invoke((Object)wsmpb, "jaxws");
            ((MuleContextAware)((Object)wsmpb)).setMuleContext(this.muleContext);
            return wsmpb.build();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage("Failed to configure the required web service infrastructure: are you missing the Mule CXF Module?"), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAX_WS,
        DEFAULT;


        public static Type fromString(String string) {
            String mepString = string.toUpperCase().replace('-', '_');
            return Type.valueOf(mepString);
        }
    }
}

