/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MessageExchangePattern;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleRuntimeException;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.ServiceException;
import org.mule.api.registry.ServiceType;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.endpoint.DefaultEndpointMessageProcessorChainFactory;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.endpoint.DefaultOutboundEndpoint;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.SecurityFilterMessageProcessorBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.TransformerUtils;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.transport.service.TransportFactoryException;
import org.mule.transport.service.TransportServiceDescriptor;
import org.mule.transport.service.TransportServiceException;
import org.mule.util.ClassUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.MapCombiner;
import org.mule.util.ObjectNameHelper;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointBuilder
implements EndpointBuilder {
    public static final String PROPERTY_RESPONSE_TIMEOUT = "responseTimeout";
    public static final String PROPERTY_RESPONSE_PROPERTIES = "responseProperties";
    protected URIBuilder uriBuilder;
    protected Connector connector;
    protected String name;
    protected Map<Object, Object> properties = new HashMap<Object, Object>();
    protected TransactionConfig transactionConfig;
    protected Boolean deleteUnacceptedMessages;
    protected Boolean synchronous;
    protected MessageExchangePattern messageExchangePattern;
    protected Integer responseTimeout;
    protected String initialState = "started";
    protected String encoding;
    protected Integer createConnector;
    protected RetryPolicyTemplate retryPolicyTemplate;
    protected String responsePropertiesList;
    protected EndpointMessageProcessorChainFactory messageProcessorsFactory;
    protected List<MessageProcessor> messageProcessors = new LinkedList<MessageProcessor>();
    protected List<MessageProcessor> responseMessageProcessors = new LinkedList<MessageProcessor>();
    protected List<Transformer> transformers = new LinkedList<Transformer>();
    protected List<Transformer> responseTransformers = new LinkedList<Transformer>();
    protected Boolean disableTransportTransformer;
    protected String mimeType;
    protected String registryId = null;
    protected MuleContext muleContext;
    protected transient Log logger = LogFactory.getLog(this.getClass());

    @Override
    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildInboundEndpoint();
    }

    @Override
    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        return this.doBuildOutboundEndpoint();
    }

    protected void setPropertiesFromProperties(Map<Object, Object> properties) {
        String mepString;
        Boolean tempSync = AbstractEndpointBuilder.getBooleanProperty(properties, "synchronous", this.synchronous);
        if (tempSync != null) {
            if (this.uriBuilder != null) {
                this.logger.warn((Object)String.format("Deprecated 'synchronous' flag found on endpoint '%s', please replace with e.g. 'exchangePattern=request-response", this.uriBuilder.getEndpoint()));
            } else {
                this.logger.warn((Object)"Deprecated 'synchronous' flag found on endpoint)");
            }
        }
        if (StringUtils.isNotEmpty((String)(mepString = (String)properties.get("exchangePattern")))) {
            this.setExchangePattern(MessageExchangePattern.fromString(mepString));
        }
        this.responseTimeout = AbstractEndpointBuilder.getIntegerProperty(properties, PROPERTY_RESPONSE_TIMEOUT, this.responseTimeout);
        this.responsePropertiesList = (String)properties.get(PROPERTY_RESPONSE_PROPERTIES);
    }

    private static Boolean getBooleanProperty(Map<Object, Object> properties, String name, Boolean dflt) {
        if (properties.containsKey(name)) {
            return Boolean.valueOf((String)properties.get(name));
        }
        return dflt;
    }

    private static Integer getIntegerProperty(Map<Object, Object> properties, String name, Integer dflt) {
        if (properties.containsKey(name)) {
            return Integer.decode((String)properties.get(name));
        }
        return dflt;
    }

    protected InboundEndpoint doBuildInboundEndpoint() throws InitialisationException, EndpointException {
        String uri = this.uriBuilder.getConstructor();
        if (this.muleContext.getExpressionManager().isExpression(uri)) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointURIsCannotBeUsedOnInbound(), uri);
        }
        this.prepareToBuildEndpoint();
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        this.addTransformersFromUri(endpointURI);
        this.addResponseTransformersFromUri(endpointURI);
        this.addTransformers();
        this.addResponseTransformers();
        Connector connector = this.getConnector();
        if (connector != null && !connector.supportsProtocol(endpointURI.getFullScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        this.checkInboundExchangePattern();
        DefaultInboundEndpoint endpoint = new DefaultInboundEndpoint(connector, endpointURI, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getDefaultDeleteUnacceptedMessages(connector), this.messageExchangePattern, this.getResponseTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.name, this.muleContext, this.getRetryPolicyTemplate(connector), this.getMessageProcessorsFactory(), this.messageProcessors, this.responseMessageProcessors, this.isDisableTransportTransformer(), this.mimeType);
        for (MessageProcessor mp : this.messageProcessors) {
            if (!(mp instanceof Transformer)) continue;
            ((Transformer)mp).setEndpoint(endpoint);
        }
        for (MessageProcessor mp : this.responseMessageProcessors) {
            if (!(mp instanceof Transformer)) continue;
            ((Transformer)mp).setEndpoint(endpoint);
        }
        return endpoint;
    }

    protected OutboundEndpoint doBuildOutboundEndpoint() throws InitialisationException, EndpointException {
        String uri = this.uriBuilder.getConstructor();
        if (this.muleContext.getExpressionManager().isExpression(uri)) {
            if (this.muleContext.getExpressionManager().isValidExpression(this.uriBuilder.getConstructor())) {
                this.uriBuilder = new URIBuilder("dynamic://endpoint", this.muleContext);
                return new DynamicOutboundEndpoint(this.muleContext, this, uri);
            }
            throw new MalformedEndpointException(uri);
        }
        this.prepareToBuildEndpoint();
        EndpointURI endpointURI = this.uriBuilder.getEndpoint();
        endpointURI.initialise();
        this.addTransformersFromUri(endpointURI);
        this.addResponseTransformersFromUri(endpointURI);
        this.addTransformers();
        this.addResponseTransformers();
        Connector connector = this.getConnector();
        if (connector != null && !connector.supportsProtocol(this.getScheme())) {
            throw new IllegalArgumentException(CoreMessages.connectorSchemeIncompatibleWithEndpointScheme(connector.getProtocol(), endpointURI).getMessage());
        }
        this.checkOutboundExchangePattern();
        DefaultOutboundEndpoint endpoint = new DefaultOutboundEndpoint(connector, endpointURI, this.getName(endpointURI), this.getProperties(), this.getTransactionConfig(), this.getDefaultDeleteUnacceptedMessages(connector), this.messageExchangePattern, this.getResponseTimeout(connector), this.getInitialState(connector), this.getEndpointEncoding(connector), this.name, this.muleContext, this.getRetryPolicyTemplate(connector), this.responsePropertiesList, this.getMessageProcessorsFactory(), this.messageProcessors, this.responseMessageProcessors, this.isDisableTransportTransformer(), this.mimeType);
        for (MessageProcessor mp : this.messageProcessors) {
            if (!(mp instanceof Transformer)) continue;
            ((Transformer)mp).setEndpoint(endpoint);
        }
        for (MessageProcessor mp : this.responseMessageProcessors) {
            if (!(mp instanceof Transformer)) continue;
            ((Transformer)mp).setEndpoint(endpoint);
        }
        return endpoint;
    }

    protected void prepareToBuildEndpoint() {
        Map<Object, Object> props = this.getProperties();
        this.setPropertiesFromProperties(props);
        if (this.uriBuilder == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("uriBuilder"));
        }
        this.uriBuilder.setMuleContext(this.muleContext);
    }

    protected void checkInboundExchangePattern() throws EndpointException {
        TransportServiceDescriptor serviceDescriptor = this.getConnectorServiceDescriptor();
        this.initExchangePatternFromConnectorDefault(serviceDescriptor);
        if (!serviceDescriptor.getInboundExchangePatterns().contains((Object)this.messageExchangePattern)) {
            throw new EndpointException(CoreMessages.exchangePatternForEndpointNotSupported(this.messageExchangePattern, "inbound", this.uriBuilder.getEndpoint()));
        }
    }

    private void checkOutboundExchangePattern() throws EndpointException {
        TransportServiceDescriptor serviceDescriptor = this.getConnectorServiceDescriptor();
        this.initExchangePatternFromConnectorDefault(serviceDescriptor);
        if (!serviceDescriptor.getOutboundExchangePatterns().contains((Object)this.messageExchangePattern)) {
            throw new EndpointException(CoreMessages.exchangePatternForEndpointNotSupported(this.messageExchangePattern, "outbound", this.uriBuilder.getEndpoint()));
        }
    }

    private TransportServiceDescriptor getConnectorServiceDescriptor() throws EndpointException {
        try {
            Connector conn = this.getConnector();
            return this.getNonNullServiceDescriptor(conn);
        }
        catch (ServiceException e) {
            throw new EndpointException(e);
        }
    }

    protected void initExchangePatternFromConnectorDefault(TransportServiceDescriptor serviceDescriptor) throws EndpointException {
        if (this.messageExchangePattern == null) {
            try {
                this.messageExchangePattern = serviceDescriptor.getDefaultExchangePattern();
            }
            catch (TransportServiceException e) {
                throw new EndpointException(e);
            }
        }
    }

    private Properties getOverrides(Connector connector) {
        Map so;
        Properties overrides = new Properties();
        if (connector instanceof AbstractConnector && (so = ((AbstractConnector)connector).getServiceOverrides()) != null) {
            overrides.putAll((Map<?, ?>)so);
        }
        return overrides;
    }

    private TransportServiceDescriptor getNonNullServiceDescriptor(Connector conn) throws ServiceException {
        String scheme = this.uriBuilder.getEndpoint().getSchemeMetaInfo();
        Properties overrides = this.getOverrides(conn);
        TransportServiceDescriptor sd = (TransportServiceDescriptor)this.muleContext.getRegistry().lookupServiceDescriptor(ServiceType.TRANSPORT, scheme, overrides);
        if (null != sd) {
            return sd;
        }
        throw new ServiceException(CoreMessages.noServiceTransportDescriptor(scheme));
    }

    protected RetryPolicyTemplate getRetryPolicyTemplate(Connector conn) {
        return this.retryPolicyTemplate != null ? this.retryPolicyTemplate : conn.getRetryPolicyTemplate();
    }

    protected TransactionConfig getTransactionConfig() {
        return this.transactionConfig != null ? this.transactionConfig : this.getDefaultTransactionConfig();
    }

    protected TransactionConfig getDefaultTransactionConfig() {
        return new MuleTransactionConfig();
    }

    protected EndpointSecurityFilter getSecurityFilter() {
        for (MessageProcessor mp : this.messageProcessors) {
            if (!(mp instanceof SecurityFilterMessageProcessorBuilder)) continue;
            return ((SecurityFilterMessageProcessorBuilder)mp).getSecurityFilter();
        }
        return null;
    }

    protected EndpointSecurityFilter getDefaultSecurityFilter() {
        return null;
    }

    protected Connector getConnector() throws EndpointException {
        return this.connector != null ? this.connector : this.getDefaultConnector();
    }

    protected Connector getDefaultConnector() throws EndpointException {
        return this.getConnector(this.uriBuilder.getEndpoint());
    }

    protected String getName(EndpointURI endpointURI) {
        return this.name != null ? this.name : new ObjectNameHelper(this.muleContext).getEndpointName(endpointURI);
    }

    protected Map<Object, Object> getProperties() {
        LinkedList<Map<Object, Object>> maps = new LinkedList<Map<Object, Object>>();
        if (null != this.uriBuilder) {
            this.uriBuilder.setMuleContext(this.muleContext);
            maps.addLast(this.uriBuilder.getEndpoint().getParams());
        }
        if (this.properties != null) {
            maps.addLast(this.properties);
        }
        MapCombiner combiner = new MapCombiner();
        combiner.setList(maps);
        return Collections.unmodifiableMap(combiner);
    }

    protected boolean getDeleteUnacceptedMessages(Connector connector) {
        return this.deleteUnacceptedMessages != null ? this.deleteUnacceptedMessages.booleanValue() : this.getDefaultDeleteUnacceptedMessages(connector);
    }

    protected boolean getDefaultDeleteUnacceptedMessages(Connector connector) {
        return false;
    }

    protected String getEndpointEncoding(Connector connector) {
        return this.encoding != null ? this.encoding : this.getDefaultEndpointEncoding(connector);
    }

    protected String getDefaultEndpointEncoding(Connector connector) {
        return this.muleContext.getConfiguration().getDefaultEncoding();
    }

    protected String getInitialState(Connector connector) {
        return this.initialState != null ? this.initialState : this.getDefaultInitialState(connector);
    }

    protected String getDefaultInitialState(Connector connector) {
        return "started";
    }

    protected int getResponseTimeout(Connector connector) {
        return this.responseTimeout != null ? this.responseTimeout.intValue() : this.getDefaultResponseTimeout(connector);
    }

    protected int getDefaultResponseTimeout(Connector connector) {
        return this.muleContext.getConfiguration().getDefaultResponseTimeout();
    }

    protected void addTransformersFromUri(EndpointURI endpointURI) throws TransportFactoryException {
        if (endpointURI.getTransformers() != null) {
            if (!CollectionUtils.containsType(this.messageProcessors, Transformer.class)) {
                this.messageProcessors.addAll(this.getTransformersFromString(endpointURI.getTransformers()));
            } else {
                this.logger.info((Object)("Endpoint with uri '" + endpointURI.toString() + "' has transformer(s) configured, transformers configured as uri paramaters will be ignored."));
            }
        }
    }

    protected void addResponseTransformersFromUri(EndpointURI endpointURI) throws TransportFactoryException {
        if (endpointURI.getResponseTransformers() != null) {
            if (!CollectionUtils.containsType(this.responseMessageProcessors, Transformer.class)) {
                this.responseMessageProcessors.addAll(this.getTransformersFromString(endpointURI.getResponseTransformers()));
            } else {
                this.logger.info((Object)("Endpoint with uri '" + endpointURI.toString() + "' has response transformer(s) configured, response transformers configured as uri paramaters will be ignored."));
            }
        }
    }

    protected void addTransformers() {
        this.messageProcessors.addAll(this.transformers);
    }

    protected void addResponseTransformers() {
        this.responseMessageProcessors.addAll(this.responseTransformers);
    }

    protected String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        if (mimeType == null) {
            this.mimeType = null;
        } else {
            MimeType mt;
            try {
                mt = new MimeType(mimeType);
            }
            catch (MimeTypeParseException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            this.mimeType = mt.getPrimaryType() + "/" + mt.getSubType();
        }
    }

    private List<Transformer> getTransformersFromString(String transformerString) throws TransportFactoryException {
        try {
            return TransformerUtils.getTransformers(transformerString, this.muleContext);
        }
        catch (DefaultMuleException e) {
            throw new TransportFactoryException(e);
        }
    }

    private Connector getConnector(EndpointURI endpointURI) throws EndpointException {
        Connector connector;
        String scheme = this.getScheme();
        TransportFactory factory = new TransportFactory(this.muleContext);
        try {
            if (this.uriBuilder.getEndpoint().getConnectorName() != null) {
                connector = this.muleContext.getRegistry().lookupConnector(this.uriBuilder.getEndpoint().getConnectorName());
                if (connector == null) {
                    throw new TransportFactoryException(CoreMessages.objectNotRegistered("Connector", this.uriBuilder.getEndpoint().getConnectorName()));
                }
            } else if (this.isAlwaysCreateConnector()) {
                connector = factory.createConnector(endpointURI);
                this.muleContext.getRegistry().registerConnector(connector);
            } else {
                connector = factory.getConnectorByProtocol(scheme);
                if (connector == null) {
                    connector = factory.createConnector(endpointURI);
                    this.muleContext.getRegistry().registerConnector(connector);
                }
            }
        }
        catch (Exception e) {
            throw new TransportFactoryException(e);
        }
        if (connector == null) {
            Message m = CoreMessages.failedToCreateObjectWith("Endpoint", "endpointURI: " + endpointURI);
            m.setNextMessage(CoreMessages.objectIsNull("connector"));
            throw new TransportFactoryException(m);
        }
        return connector;
    }

    protected String getScheme() {
        return this.uriBuilder.getEndpoint().getFullScheme();
    }

    protected boolean isAlwaysCreateConnector() {
        return false;
    }

    @Override
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    @Deprecated
    public void addTransformer(Transformer transformer) {
        this.transformers.add(transformer);
    }

    @Override
    @Deprecated
    public void setTransformers(List<Transformer> newTransformers) {
        if (newTransformers == null) {
            newTransformers = new LinkedList<Transformer>();
        }
        this.transformers = newTransformers;
    }

    protected EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.messageProcessorsFactory != null ? this.messageProcessorsFactory : this.getDefaultMessageProcessorsFactory();
    }

    protected EndpointMessageProcessorChainFactory getDefaultMessageProcessorsFactory() {
        return new DefaultEndpointMessageProcessorChainFactory();
    }

    @Override
    @Deprecated
    public void addResponseTransformer(Transformer transformer) {
        this.responseTransformers.add(transformer);
    }

    @Override
    @Deprecated
    public void setResponseTransformers(List<Transformer> newResponseTransformers) {
        if (newResponseTransformers == null) {
            newResponseTransformers = new LinkedList<Transformer>();
        }
        this.responseTransformers = newResponseTransformers;
    }

    @Override
    public void addMessageProcessor(MessageProcessor messageProcessor) {
        this.messageProcessors.add(messageProcessor);
    }

    @Override
    public void setMessageProcessors(List<MessageProcessor> newMessageProcessors) {
        if (newMessageProcessors == null) {
            newMessageProcessors = new LinkedList<MessageProcessor>();
        }
        this.messageProcessors = newMessageProcessors;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.messageProcessors;
    }

    @Override
    public void addResponseMessageProcessor(MessageProcessor messageProcessor) {
        this.responseMessageProcessors.add(messageProcessor);
    }

    @Override
    public void setResponseMessageProcessors(List<MessageProcessor> newResponseMessageProcessors) {
        if (newResponseMessageProcessors == null) {
            newResponseMessageProcessors = new LinkedList<MessageProcessor>();
        }
        this.responseMessageProcessors = newResponseMessageProcessors;
    }

    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.responseMessageProcessors;
    }

    protected boolean isDisableTransportTransformer() {
        return this.disableTransportTransformer != null ? this.disableTransportTransformer.booleanValue() : this.getDefaultDisableTransportTransformer();
    }

    protected boolean getDefaultDisableTransportTransformer() {
        return false;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        if (null == this.properties) {
            this.properties = new HashMap<Object, Object>();
        }
        this.properties.putAll(properties);
    }

    @Override
    public void setProperty(Object key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public void setTransactionConfig(TransactionConfig transactionConfig) {
        this.transactionConfig = transactionConfig;
    }

    @Override
    public void setDeleteUnacceptedMessages(boolean deleteUnacceptedMessages) {
        this.deleteUnacceptedMessages = deleteUnacceptedMessages;
    }

    @Override
    public void setExchangePattern(MessageExchangePattern mep) {
        this.messageExchangePattern = mep;
    }

    @Override
    public void setResponseTimeout(int responseTimeout) {
        this.responseTimeout = new Integer(responseTimeout);
    }

    @Override
    public void setInitialState(String initialState) {
        this.initialState = initialState;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCreateConnector(int createConnector) {
        this.createConnector = new Integer(createConnector);
    }

    @Override
    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    @Override
    public void setDisableTransportTransformer(boolean disableTransportTransformer) {
        this.disableTransportTransformer = disableTransportTransformer;
    }

    public URIBuilder getEndpointBuilder() {
        return this.uriBuilder;
    }

    @Override
    public void setURIBuilder(URIBuilder URIBuilder2) {
        this.uriBuilder = URIBuilder2;
    }

    public int hashCode() {
        return ClassUtils.hash(new Object[]{this.retryPolicyTemplate, this.connector, this.createConnector, this.deleteUnacceptedMessages, this.encoding, this.uriBuilder, this.initialState, this.name, this.properties, this.responseTimeout, this.responseMessageProcessors, this.synchronous, this.messageExchangePattern, this.transactionConfig, this.messageProcessors, this.disableTransportTransformer, this.mimeType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractEndpointBuilder other = (AbstractEndpointBuilder)obj;
        return AbstractEndpointBuilder.equal(this.retryPolicyTemplate, other.retryPolicyTemplate) && AbstractEndpointBuilder.equal(this.connector, other.connector) && AbstractEndpointBuilder.equal(this.createConnector, other.createConnector) && AbstractEndpointBuilder.equal(this.deleteUnacceptedMessages, other.deleteUnacceptedMessages) && AbstractEndpointBuilder.equal(this.encoding, other.encoding) && AbstractEndpointBuilder.equal(this.uriBuilder, other.uriBuilder) && AbstractEndpointBuilder.equal(this.initialState, other.initialState) && AbstractEndpointBuilder.equal(this.name, other.name) && AbstractEndpointBuilder.equal(this.properties, other.properties) && AbstractEndpointBuilder.equal(this.responseTimeout, other.responseTimeout) && AbstractEndpointBuilder.equal(this.messageProcessors, other.messageProcessors) && AbstractEndpointBuilder.equal(this.synchronous, other.synchronous) && AbstractEndpointBuilder.equal((Object)this.messageExchangePattern, (Object)other.messageExchangePattern) && AbstractEndpointBuilder.equal(this.transactionConfig, other.transactionConfig) && AbstractEndpointBuilder.equal(this.responseMessageProcessors, other.responseMessageProcessors) && AbstractEndpointBuilder.equal(this.disableTransportTransformer, other.disableTransportTransformer) && AbstractEndpointBuilder.equal(this.mimeType, other.mimeType);
    }

    protected static boolean equal(Object a, Object b) {
        return ClassUtils.equal(a, b);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EndpointBuilder builder = (EndpointBuilder)super.clone();
        builder.setConnector(this.connector);
        builder.setURIBuilder(this.uriBuilder);
        builder.setMessageProcessors(this.messageProcessors);
        builder.setResponseMessageProcessors(this.responseMessageProcessors);
        builder.setName(this.name);
        builder.setProperties(this.properties);
        builder.setTransactionConfig(this.transactionConfig);
        builder.setInitialState(this.initialState);
        builder.setEncoding(this.encoding);
        builder.setRegistryId(this.registryId);
        builder.setMuleContext(this.muleContext);
        builder.setRetryPolicyTemplate(this.retryPolicyTemplate);
        builder.setTransformers(this.transformers);
        builder.setResponseTransformers(this.responseTransformers);
        if (this.deleteUnacceptedMessages != null) {
            builder.setDeleteUnacceptedMessages(this.deleteUnacceptedMessages);
        }
        if (this.messageExchangePattern != null) {
            builder.setExchangePattern(this.messageExchangePattern);
        }
        if (this.responseTimeout != null) {
            builder.setResponseTimeout(this.responseTimeout);
        }
        if (this.disableTransportTransformer != null) {
            builder.setDisableTransportTransformer(this.disableTransportTransformer);
        }
        return builder;
    }
}

