/*
 * Decompiled with CFR 0.152.
 */
package org.mule.processor;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.security.SecurityException;
import org.mule.context.notification.SecurityNotification;
import org.mule.message.DefaultExceptionPayload;
import org.mule.processor.AbstractInterceptingMessageProcessor;
import org.mule.transport.AbstractConnector;

public class SecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor {
    private EndpointSecurityFilter filter;

    public SecurityFilterMessageProcessor() {
    }

    public SecurityFilterMessageProcessor(EndpointSecurityFilter filter) {
        this.filter = filter;
    }

    public EndpointSecurityFilter getFilter() {
        return this.filter;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        if (this.filter != null) {
            try {
                this.filter.authenticate(event);
            }
            catch (SecurityException e) {
                this.logger.warn((Object)("Outbound Request was made but was not authenticated: " + e.getMessage()), (Throwable)e);
                ((AbstractConnector)event.getEndpoint().getConnector()).fireNotification(new SecurityNotification(e, 401));
                event.getFlowConstruct().getExceptionListener().handleException(e, event);
                event.getMessage().setPayload(e.getLocalizedMessage());
                event.getMessage().setExceptionPayload(new DefaultExceptionPayload(e));
                return event;
            }
        }
        return this.processNext(event);
    }

    public void setFilter(EndpointSecurityFilter filter) {
        this.filter = filter;
    }
}

