/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractFilteringMessageProcessor;

public class MessageFilter
extends AbstractFilteringMessageProcessor {
    protected Filter filter;
    protected MessageProcessor unacceptedMessageProcessor;
    protected boolean throwOnUnaccepted;

    public MessageFilter() {
    }

    public MessageFilter(Filter filter) {
        this.filter = filter;
    }

    public MessageFilter(Filter filter, MessageProcessor messageProcessor) {
        this.filter = filter;
    }

    protected boolean accept(MuleEvent event) {
        if (this.filter == null) {
            return true;
        }
        if (event != null) {
            return this.filter.accept(event.getMessage());
        }
        return false;
    }

    protected MuleEvent handleUnaccepted(MuleEvent event) throws MuleException {
        if (this.unacceptedMessageProcessor == null) {
            super.handleUnaccepted(event);
        } else {
            this.unacceptedMessageProcessor.process(event);
        }
        if (this.throwOnUnaccepted) {
            throw new FilterUnacceptedException(CoreMessages.messageRejectedByFilter(), event, this.filter);
        }
        return null;
    }

    public void setUnacceptedMessageProcessor(MessageProcessor unacceptedMessageProcessor) {
        this.unacceptedMessageProcessor = unacceptedMessageProcessor;
    }

    public MessageProcessor getUnacceptedMessageProcessor() {
        return this.unacceptedMessageProcessor;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setThrowOnUnaccepted(boolean throwOnUnaccepted) {
        this.throwOnUnaccepted = throwOnUnaccepted;
    }

    public String toString() {
        return (this.filter == null ? "null filter" : this.filter.getClass().getName()) + " (wrapped by " + this.getClass().getSimpleName() + ")";
    }
}

