/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.mule.DefaultMuleEvent;
import org.mule.OptimizedRequestContext;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.context.WorkManager;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.api.transport.PropertyScope;
import org.mule.session.DefaultMuleSession;
import org.mule.session.LegacySessionHandler;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractConnectable;
import org.mule.transport.ConnectableLifecycleManager;
import org.mule.util.ClassUtils;
import org.mule.util.ObjectUtils;

public abstract class AbstractMessageReceiver
extends AbstractConnectable
implements MessageReceiver {
    protected FlowConstruct flowConstruct;
    protected MessageProcessor listener;
    protected String receiverKey = null;
    private EndpointURI endpointUri;
    private List<Transformer> defaultInboundTransformers;
    private List<Transformer> defaultResponseTransformers;

    public AbstractMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(endpoint);
        if (flowConstruct == null) {
            throw new IllegalArgumentException("FlowConstruct cannot be null");
        }
        this.flowConstruct = flowConstruct;
    }

    protected ConnectableLifecycleManager createLifecycleManager() {
        return new ConnectableLifecycleManager<AbstractMessageReceiver>(this.getReceiverKey(), this);
    }

    public final void initialise() throws InitialisationException {
        this.endpointUri = this.endpoint.getEndpointURI();
        this.defaultInboundTransformers = this.connector.getDefaultInboundTransformers(this.endpoint);
        this.defaultResponseTransformers = this.connector.getDefaultResponseTransformers(this.endpoint);
        super.initialise();
    }

    public FlowConstruct getFlowConstruct() {
        return this.flowConstruct;
    }

    public final MuleEvent routeMessage(MuleMessage message) throws MuleException {
        Transaction tx = TransactionCoordination.getInstance().getTransaction();
        return this.routeMessage(message, tx, null);
    }

    public final MuleEvent routeMessage(MuleMessage message, Transaction trans) throws MuleException {
        return this.routeMessage(message, trans, null);
    }

    public final MuleEvent routeMessage(MuleMessage message, Transaction trans, OutputStream outputStream) throws MuleException {
        return this.routeMessage(message, new DefaultMuleSession(this.connector.getMuleContext()), trans, outputStream);
    }

    public final MuleEvent routeMessage(MuleMessage message, MuleSession session, Transaction trans, OutputStream outputStream) throws MuleException {
        MuleEvent resultEvent;
        Object o = message.getInboundProperty("MULE_REMOTE_SYNC");
        if (ObjectUtils.getBoolean(o, false) && !this.endpoint.getExchangePattern().hasResponse()) {
            this.logger.warn((Object)("MuleClient.send() was used but inbound endpoint " + this.endpoint.getEndpointURI().getUri().toString() + " is not 'request-response'.  No response will be returned."));
        }
        message.removeProperty("MULE_REMOTE_SYNC", PropertyScope.INBOUND);
        MuleEvent muleEvent = this.createMuleEvent(message, outputStream);
        muleEvent = OptimizedRequestContext.unsafeSetEvent(muleEvent);
        if (!this.endpoint.isDisableTransportTransformer()) {
            this.applyInboundTransformers(muleEvent);
        }
        if ((resultEvent = this.listener.process(muleEvent)) != null && resultEvent.getMessage() != null && resultEvent.getMessage().getExceptionPayload() != null && resultEvent.getMessage().getExceptionPayload().getException() instanceof FilterUnacceptedException) {
            this.handleUnacceptedFilter(muleEvent.getMessage());
            return muleEvent;
        }
        if (resultEvent != null && resultEvent.getMessage() != null && !this.endpoint.isDisableTransportTransformer()) {
            this.applyResponseTransformers(resultEvent);
        }
        return resultEvent;
    }

    protected void applyInboundTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultInboundTransformers);
    }

    protected void applyResponseTransformers(MuleEvent event) throws MuleException {
        event.getMessage().applyTransformers(event, this.defaultResponseTransformers);
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            String messageId = message.getUniqueId();
            this.logger.debug((Object)("Message " + messageId + " failed to pass filter on endpoint: " + this.endpoint + ". Message is being ignored"));
        }
        return message;
    }

    protected MuleEvent createMuleEvent(MuleMessage message, OutputStream outputStream) throws MuleException {
        MuleSession session;
        ResponseOutputStream ros = null;
        if (outputStream != null) {
            ros = outputStream instanceof ResponseOutputStream ? (ResponseOutputStream)outputStream : new ResponseOutputStream(outputStream);
        }
        try {
            session = this.connector.getSessionHandler().retrieveSessionInfoFromMessage(message);
        }
        catch (SerializationException e) {
            session = new LegacySessionHandler().retrieveSessionInfoFromMessage(message);
        }
        if (session != null) {
            session.setFlowConstruct(this.flowConstruct);
        } else {
            session = new DefaultMuleSession(this.flowConstruct, this.connector.getMuleContext());
        }
        return new DefaultMuleEvent(message, this.endpoint, session, ros);
    }

    public EndpointURI getEndpointURI() {
        return this.endpointUri;
    }

    public String getConnectionDescription() {
        return this.endpoint.getEndpointURI().toString();
    }

    protected String getConnectEventId() {
        return this.connector.getName() + ".receiver (" + this.endpoint.getEndpointURI() + ")";
    }

    public void setReceiverKey(String receiverKey) {
        this.receiverKey = receiverKey;
    }

    public String getReceiverKey() {
        return this.receiverKey;
    }

    public InboundEndpoint getEndpoint() {
        return (InboundEndpoint)super.getEndpoint();
    }

    public void setEndpoint(InboundEndpoint endpoint) {
        super.setEndpoint(endpoint);
    }

    protected WorkManager getWorkManager() {
        try {
            return this.connector.getReceiverWorkManager();
        }
        catch (MuleException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(80);
        sb.append(ClassUtils.getSimpleName(this.getClass()));
        sb.append("{this=").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(", receiverKey=").append(this.receiverKey);
        sb.append(", endpoint=").append(this.endpoint.getEndpointURI());
        sb.append('}');
        return sb.toString();
    }

    public void setListener(MessageProcessor processor) {
        this.listener = processor;
    }
}

