/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.PropertyScope;
import org.mule.config.endpoint.AnnotatedEndpointData;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.endpoint.MuleEndpointURI;
import org.mule.transport.AbstractConnector;
import org.mule.transport.service.TransportFactory;
import org.mule.util.BeanUtils;
import org.mule.util.TemplateParser;
import org.mule.util.UriParamFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallOutboundEndpoint
extends DynamicOutboundEndpoint {
    public static final String NULL_PARAM = "null.param";
    protected final transient Log logger = LogFactory.getLog(CallOutboundEndpoint.class);
    private static final long serialVersionUID = 1861985949279708638L;
    protected TemplateParser parser = TemplateParser.createCurlyBracesStyleParser();
    private UriParamFilter filter = new UriParamFilter();

    public CallOutboundEndpoint(MuleContext context, AnnotatedEndpointData epData) throws MalformedEndpointException {
        super(context, CallOutboundEndpoint.createBuilder(context, epData), epData.getAddress());
    }

    private static synchronized EndpointBuilder createBuilder(MuleContext context, AnnotatedEndpointData epData) {
        try {
            String address = epData.getAddress();
            int i = address.indexOf(":/");
            if (i > -1) {
                HashMap props;
                String scheme = address.substring(0, i);
                address = scheme + "://dynamic";
                MuleEndpointURI tempUri = new MuleEndpointURI(address, context);
                AbstractConnector cnn = null;
                if (epData.getConnectorName() != null) {
                    cnn = (AbstractConnector)context.getRegistry().lookupConnector(epData.getConnectorName());
                }
                if (cnn == null) {
                    cnn = (AbstractConnector)new TransportFactory(context).createConnector((EndpointURI)tempUri);
                    if (epData.getConnectorName() != null) {
                        cnn.setName(epData.getConnectorName());
                    }
                    context.getRegistry().registerConnector((Connector)cnn);
                }
                if ((props = epData.getProperties()) == null) {
                    props = new HashMap();
                } else {
                    BeanUtils.populateWithoutFail((Object)cnn, props, (boolean)false);
                }
                EndpointBuilder builder = context.getRegistry().lookupEndpointFactory().getEndpointBuilder(address);
                builder.setExchangePattern(epData.getMep());
                builder.setConnector((Connector)cnn);
                builder.setName(epData.getName());
                builder.setProperties(props);
                return builder;
            }
            throw new IllegalArgumentException("When defining a dynamic endpoint the endpoint scheme must be set i.e. http://{dynamic}");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void validateUriTemplate(String uri) throws MalformedEndpointException {
    }

    protected String parseURIString(String uri, MuleMessage message) {
        Map<String, Object> props = this.getPropertiesForUriTemplate(message);
        String newUriString = this.parser.parse(props, uri);
        newUriString = this.filter.filterParamsByValue(newUriString, NULL_PARAM);
        return super.parseURIString(newUriString, message);
    }

    protected Map<String, Object> getPropertiesForUriTemplate(MuleMessage message) {
        Map props = (Map)message.getOutboundProperty("ibeans.uri.params");
        if (props == null) {
            throw new IllegalStateException("ibeans.uri.params not set on message");
        }
        return props;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent result = super.process(event);
        if (result != null) {
            result.getMessage().setProperty("ibeans.call.uri", (Object)event.getEndpoint().getEndpointURI().toString(), PropertyScope.OUTBOUND);
        }
        return result;
    }
}

