/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ibean;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.ibeans.impl.IBeansNotationHelper;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.DispatchException;
import org.mule.module.ibeans.i18n.IBeansMessages;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.ibean.IBeansConnector;

public class IBeansMessageDispatcher
extends AbstractMessageDispatcher {
    private Object ibean;
    private String method;
    private String ibeanName;

    public IBeansMessageDispatcher(OutboundEndpoint endpoint) throws MuleException {
        super(endpoint);
        List state = (List)endpoint.getProperty((Object)"ibean.state.params");
        if (state == null) {
            state = Collections.emptyList();
        }
        IBeansConnector cnn = (IBeansConnector)this.getConnector();
        this.ibean = cnn.createIbean(endpoint.getEndpointURI(), state);
        this.ibeanName = IBeansNotationHelper.getIBeanShortID(this.ibean.getClass().getInterfaces()[0]);
        String address = endpoint.getEndpointURI().getAddress();
        this.method = address.substring(address.indexOf(".") + 1);
    }

    public void doDispatch(MuleEvent event) throws Exception {
        this.doSend(event);
    }

    public MuleMessage doSend(MuleEvent event) throws Exception {
        Method callMethod;
        Object payload = event.getMessage().getPayload();
        Object[] params = payload.getClass().isArray() ? (Object[])payload : new Object[]{payload};
        Class[] types = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            types[i] = params[i].getClass();
        }
        String methodName = (String)event.getMessage().getInvocationProperty("method", (Object)this.method);
        try {
            callMethod = this.ibean.getClass().getMethod(methodName, types);
        }
        catch (Throwable e) {
            throw new DispatchException(IBeansMessages.ibeanMethodNotFound(this.ibeanName, methodName, types), event.getMessage(), (MessageProcessor)this, e);
        }
        Object result = callMethod.invoke(this.ibean, params);
        return new DefaultMuleMessage(result, event.getMessage(), event.getMuleContext());
    }
}

