/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.binding.soap;

import java.lang.reflect.Method;
import javax.jws.soap.SOAPBinding;
import org.apache.cxf.binding.soap.SoapBindingConfiguration;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsSoapBindingConfiguration
extends SoapBindingConfiguration {
    JaxWsServiceFactoryBean serviceFactory;

    public JaxWsSoapBindingConfiguration(JaxWsServiceFactoryBean sifb) {
        this.serviceFactory = sifb;
    }

    public void setJaxWsServiceFactoryBean(JaxWsServiceFactoryBean b) {
        this.serviceFactory = b;
    }

    public String getStyle(OperationInfo op) {
        Method m = (Method)op.getProperty("operation.method", Method.class);
        if (m != null) {
            return this.serviceFactory.isRPC(m) ? "rpc" : "document";
        }
        return this.getStyle();
    }

    public String getStyle() {
        SOAPBinding sb = this.getServiceClass().getAnnotation(SOAPBinding.class);
        if (sb != null) {
            if (sb.style().equals((Object)SOAPBinding.Style.DOCUMENT)) {
                return "document";
            }
            if (sb.style().equals((Object)SOAPBinding.Style.RPC)) {
                return "rpc";
            }
        }
        return super.getStyle();
    }

    Class<?> getServiceClass() {
        return this.getJaxWsServiceFactory().getJaxWsImplementorInfo().getEndpointClass();
    }

    private JaxWsServiceFactoryBean getJaxWsServiceFactory() {
        return this.serviceFactory;
    }

    public String getUse() {
        SOAPBinding sb = this.getServiceClass().getAnnotation(SOAPBinding.class);
        if (sb != null) {
            if (sb.use().equals((Object)SOAPBinding.Use.LITERAL)) {
                return "literal";
            }
            if (sb.use().equals((Object)SOAPBinding.Use.ENCODED)) {
                return "encoded";
            }
        }
        return super.getUse();
    }
}

