/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.http;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import javax.resource.spi.work.Work;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.OptimizedRequestContext;
import org.mule.RequestContext;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageReceiver;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.session.DefaultMuleSession;
import org.mule.transport.ConnectException;
import org.mule.transport.NullPayload;
import org.mule.transport.http.HttpConnector;
import org.mule.transport.http.HttpMuleMessageFactory;
import org.mule.transport.http.HttpRequest;
import org.mule.transport.http.HttpResponse;
import org.mule.transport.http.HttpServerConnection;
import org.mule.transport.http.RequestLine;
import org.mule.transport.http.i18n.HttpMessages;
import org.mule.transport.tcp.TcpConnector;
import org.mule.transport.tcp.TcpMessageReceiver;
import org.mule.util.MapUtils;
import org.mule.util.monitor.Expirable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageReceiver
extends TcpMessageReceiver {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    public HttpMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    protected Work createWork(Socket socket) throws IOException {
        return new HttpWorker(socket);
    }

    protected void doConnect() throws ConnectException {
        if (this.shouldConnect()) {
            super.doConnect();
        }
    }

    protected boolean shouldConnect() {
        MessageReceiver[] receivers;
        StringBuffer requestUri = new StringBuffer(80);
        requestUri.append(this.endpoint.getProtocol()).append("://");
        requestUri.append(this.endpoint.getEndpointURI().getHost());
        requestUri.append(':').append(this.endpoint.getEndpointURI().getPort());
        requestUri.append('*');
        for (MessageReceiver receiver : receivers = this.connector.getReceivers(requestUri.toString())) {
            if (!receiver.isConnected()) continue;
            return false;
        }
        return true;
    }

    protected MessageReceiver getTargetReceiver(MuleMessage message, ImmutableEndpoint ep) throws ConnectException {
        MessageReceiver receiver;
        String path = (String)message.getInboundProperty("http.request");
        int i = path.indexOf(63);
        if (i > -1) {
            path = path.substring(0, i);
        }
        StringBuffer requestUri = new StringBuffer(80);
        if (path.indexOf("://") == -1) {
            requestUri.append(ep.getProtocol()).append("://");
            requestUri.append(ep.getEndpointURI().getHost());
            requestUri.append(':').append(ep.getEndpointURI().getPort());
            if (!"/".equals(path)) {
                requestUri.append(path);
            }
        }
        String uriStr = requestUri.toString();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Looking up receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
        }
        if ((receiver = this.connector.lookupReceiver(uriStr)) == null && !"/".equals(path)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Secondary lookup of receiver on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
            }
            if ((receiver = HttpMessageReceiver.findReceiverByStem(this.connector.getReceivers(), uriStr)) == null && this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("No receiver found with secondary lookup on connector: " + this.connector.getName() + " with URI key: " + requestUri.toString()));
                this.logger.warn((Object)("Receivers on connector are: " + MapUtils.toString((Map)this.connector.getReceivers(), (boolean)true)));
            }
        }
        return receiver;
    }

    protected HttpResponse transformResponse(Object response, MuleEvent event) throws MuleException {
        Object message = response instanceof MuleMessage ? (MuleMessage)response : new DefaultMuleMessage(response, this.connector.getMuleContext());
        message.applyTransformers(null, this.connector.getDefaultResponseTransformers(this.endpoint), HttpResponse.class);
        return (HttpResponse)message.getPayload();
    }

    public static MessageReceiver findReceiverByStem(Map<Object, MessageReceiver> receivers, String uriStr) {
        int match = 0;
        MessageReceiver receiver = null;
        for (Map.Entry<Object, MessageReceiver> e : receivers.entrySet()) {
            String key = (String)e.getKey();
            MessageReceiver candidate = e.getValue();
            if (!uriStr.startsWith(key) || match >= key.length()) continue;
            match = key.length();
            receiver = candidate;
        }
        return receiver;
    }

    protected void initializeMessageFactory() throws InitialisationException {
        try {
            HttpMuleMessageFactory factory = (HttpMuleMessageFactory)super.createMuleMessageFactory();
            boolean enableCookies = MapUtils.getBooleanValue((Map)this.endpoint.getProperties(), (Object)"enableCookies", (boolean)((HttpConnector)this.connector).isEnableCookies());
            factory.setEnableCookies(enableCookies);
            String cookieSpec = MapUtils.getString((Map)this.endpoint.getProperties(), (Object)"cookieSpec", (String)((HttpConnector)this.connector).getCookieSpec());
            factory.setCookieSpec(cookieSpec);
            factory.setExchangePattern(this.endpoint.getExchangePattern());
            this.muleMessageFactory = factory;
        }
        catch (CreateException ce) {
            Message message = MessageFactory.createStaticMessage((String)ce.getMessage());
            throw new InitialisationException(message, (Throwable)ce, (Initialisable)this);
        }
    }

    protected MuleMessage handleUnacceptedFilter(MuleMessage message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Message request '" + message.getInboundProperty("http.request") + "' is being rejected since it does not match the filter on this endpoint: " + this.endpoint));
        }
        message.setOutboundProperty("http.status", (Object)String.valueOf(406));
        return message;
    }

    protected class HttpWorker
    implements Work,
    Expirable {
        private HttpServerConnection conn;
        private String remoteClientAddress;

        public HttpWorker(Socket socket) throws IOException {
            String encoding = HttpMessageReceiver.this.endpoint.getEncoding();
            if (encoding == null) {
                encoding = HttpMessageReceiver.this.connector.getMuleContext().getConfiguration().getDefaultEncoding();
            }
            this.conn = new HttpServerConnection(socket, encoding, (HttpConnector)HttpMessageReceiver.this.connector);
            SocketAddress clientAddress = socket.getRemoteSocketAddress();
            if (clientAddress != null) {
                this.remoteClientAddress = clientAddress.toString();
            }
        }

        public void expired() {
            if (this.conn.isOpen()) {
                this.conn.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            long keepAliveTimeout = ((TcpConnector)HttpMessageReceiver.this.connector).getKeepAliveTimeout();
            try {
                do {
                    HttpRequest request;
                    this.conn.setKeepAlive(false);
                    if (keepAliveTimeout > 0L) {
                        ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().addExpirable(keepAliveTimeout, TimeUnit.MILLISECONDS, (Expirable)this);
                    }
                    if ((request = this.conn.readRequest()) == null) {
                        break;
                    }
                    ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable((Expirable)this);
                    this.conn.writeResponse(this.processRequest(request));
                    if (request.getBody() == null) continue;
                    request.getBody().close();
                } while (this.conn.isKeepAlive());
            }
            catch (Exception e) {
                HttpMessageReceiver.this.getConnector().getMuleContext().getExceptionListener().handleException(e);
            }
            finally {
                HttpMessageReceiver.this.logger.debug((Object)"Closing HTTP connection.");
                if (this.conn.isOpen()) {
                    this.conn.close();
                    this.conn = null;
                    ((HttpConnector)HttpMessageReceiver.this.connector).getKeepAliveMonitor().removeExpirable((Expirable)this);
                }
            }
        }

        protected HttpResponse processRequest(HttpRequest request) throws MuleException, IOException {
            RequestLine requestLine = request.getRequestLine();
            String method = requestLine.getMethod();
            if (method.equals("GET") || method.equals("HEAD") || method.equals("POST") || method.equals("OPTIONS") || method.equals("PUT") || method.equals("DELETE") || method.equals("TRACE") || method.equals("CONNECT")) {
                return this.doRequest(request);
            }
            return this.doBad(requestLine);
        }

        protected HttpResponse doRequest(HttpRequest request) throws IOException, MuleException {
            HttpResponse response;
            MessageReceiver receiver;
            this.sendExpect100(request);
            MuleMessage message = HttpMessageReceiver.this.createMuleMessage(request);
            String path = (String)message.getInboundProperty("http.request");
            int i = path.indexOf(63);
            if (i > -1) {
                path = path.substring(0, i);
            }
            message.setInboundProperty("http.request.path", (Object)path);
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug(message.getInboundProperty("http.request"));
            }
            if ((receiver = HttpMessageReceiver.this.getTargetReceiver(message, HttpMessageReceiver.this.endpoint)) != null) {
                message.setInboundProperty("http.context.path", (Object)HttpConnector.normalizeUrl(receiver.getEndpointURI().getPath()));
                this.preRouteMessage(message);
                MuleEvent returnEvent = receiver.routeMessage(message);
                MuleMessage returnMessage = returnEvent == null ? null : returnEvent.getMessage();
                Object tempResponse = returnMessage != null ? returnMessage.getPayload() : NullPayload.getInstance();
                response = tempResponse instanceof HttpResponse ? (HttpResponse)tempResponse : HttpMessageReceiver.this.transformResponse(returnMessage, returnEvent);
                response.setupKeepAliveFromRequestVersion(request.getRequestLine().getHttpVersion());
                HttpConnector httpConnector = (HttpConnector)HttpMessageReceiver.this.connector;
                response.disableKeepAlive(!httpConnector.isKeepAlive());
                Header connectionHeader = request.getFirstHeader("Connection");
                if (connectionHeader != null) {
                    String value = connectionHeader.getValue();
                    boolean endpointOverride = this.getEndpointKeepAliveValue(HttpMessageReceiver.this.endpoint);
                    if ("keep-alive".equalsIgnoreCase(value) && endpointOverride) {
                        response.setKeepAlive(true);
                        if (response.getHttpVersion().equals(HttpVersion.HTTP_1_0)) {
                            connectionHeader = new Header("Connection", "Keep-Alive");
                            response.setHeader(connectionHeader);
                        }
                    } else if ("close".equalsIgnoreCase(value)) {
                        response.setKeepAlive(false);
                    }
                }
            } else {
                response = this.buildFailureResponse(request.getRequestLine(), message);
            }
            return response;
        }

        private boolean getEndpointKeepAliveValue(ImmutableEndpoint ep) {
            String value = (String)ep.getProperty((Object)"keepAlive");
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
            return true;
        }

        protected HttpResponse doOtherValid(RequestLine requestLine, String method) throws MuleException {
            MuleMessage message = HttpMessageReceiver.this.createMuleMessage(null);
            DefaultMuleEvent event = new DefaultMuleEvent(message, HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.connector.getMuleContext()));
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 405);
            response.setBody(HttpMessages.methodNotAllowed(method).toString() + "\r\n");
            return HttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        protected HttpResponse doBad(RequestLine requestLine) throws MuleException {
            MuleMessage message = HttpMessageReceiver.this.createMuleMessage(null);
            DefaultMuleEvent event = new DefaultMuleEvent(message, HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.connector.getMuleContext()));
            OptimizedRequestContext.unsafeSetEvent((MuleEvent)event);
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 400);
            response.setBody(HttpMessages.malformedSyntax().toString() + "\r\n");
            return HttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        private void sendExpect100(HttpRequest request) throws MuleException, IOException {
            String expectHeaderValue;
            Header expectHeader;
            RequestLine requestLine = request.getRequestLine();
            HttpVersion requestVersion = requestLine.getHttpVersion();
            if (HttpVersion.HTTP_1_1.equals(requestVersion) && (expectHeader = request.getFirstHeader("Expect")) != null && "100-continue".equals(expectHeaderValue = expectHeader.getValue())) {
                HttpResponse expected = new HttpResponse();
                expected.setStatusLine(requestLine.getHttpVersion(), 100);
                DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)expected, HttpMessageReceiver.this.connector.getMuleContext()), HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.flowConstruct, HttpMessageReceiver.this.connector.getMuleContext()));
                RequestContext.setEvent((MuleEvent)event);
                this.conn.writeResponse(HttpMessageReceiver.this.transformResponse(expected, (MuleEvent)event));
            }
        }

        protected HttpResponse buildFailureResponse(RequestLine requestLine, MuleMessage message) throws MuleException {
            EndpointURI uri = HttpMessageReceiver.this.endpoint.getEndpointURI();
            String failedPath = String.format("%s://%s:%d%s", uri.getScheme(), uri.getHost(), uri.getPort(), message.getInboundProperty("http.request.path"));
            if (HttpMessageReceiver.this.logger.isDebugEnabled()) {
                HttpMessageReceiver.this.logger.debug((Object)("Failed to bind to " + failedPath));
            }
            HttpResponse response = new HttpResponse();
            response.setStatusLine(requestLine.getHttpVersion(), 404);
            response.setBody(HttpMessages.cannotBindToAddress(failedPath).toString());
            DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)response, HttpMessageReceiver.this.connector.getMuleContext()), HttpMessageReceiver.this.endpoint, (MuleSession)new DefaultMuleSession(HttpMessageReceiver.this.flowConstruct, HttpMessageReceiver.this.connector.getMuleContext()));
            RequestContext.setEvent((MuleEvent)event);
            return HttpMessageReceiver.this.transformResponse(response, (MuleEvent)event);
        }

        protected void preRouteMessage(MuleMessage message) throws MessagingException {
            message.setInboundProperty("MULE_REMOTE_CLIENT_ADDRESS", (Object)this.remoteClientAddress);
        }

        public void release() {
            this.conn.close();
            this.conn = null;
        }
    }
}

