/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ajax;

import org.cometd.Bayeux;
import org.cometd.Client;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.BayeuxService;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractConnector;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.ajax.BayeuxAware;
import org.mule.transport.ajax.i18n.AjaxMessages;
import org.mule.util.StringUtils;

public class AjaxMessageReceiver
extends AbstractMessageReceiver
implements BayeuxAware {
    private AbstractBayeux bayeux;

    public AjaxMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
        String channel = endpoint.getEndpointURI().getPath();
        if (StringUtils.isEmpty((String)channel) || channel.equals("/")) {
            throw new CreateException(AjaxMessages.createStaticMessage("The subscription path cannot be empty or equal '/'"), (Object)this);
        }
    }

    public AbstractBayeux getBayeux() {
        return this.bayeux;
    }

    public void setBayeux(AbstractBayeux bayeux) {
        this.bayeux = bayeux;
    }

    protected void doStart() throws MuleException {
        String channel = this.endpoint.getEndpointURI().getPath();
        new ReceiverService(channel, (Bayeux)this.getBayeux(), this.getEndpoint());
    }

    public class ReceiverService
    extends BayeuxService {
        private final ImmutableEndpoint endpoint;

        public ReceiverService(String channel, Bayeux bayeux, ImmutableEndpoint endpoint) {
            super(bayeux, channel);
            this.endpoint = endpoint;
            this.subscribe(channel, "route");
        }

        public Object route(Client client, Object data) throws Exception {
            MuleMessage message;
            AbstractConnector connector = (AbstractConnector)AjaxMessageReceiver.this.getConnector();
            MuleMessage messageToRoute = AjaxMessageReceiver.this.createMuleMessage(data, this.endpoint.getEncoding());
            messageToRoute.setInvocationProperty("cometd.client", client);
            Object replyTo = messageToRoute.getReplyTo();
            MuleEvent event = AjaxMessageReceiver.this.routeMessage(messageToRoute);
            MuleMessage muleMessage = message = event == null ? null : event.getMessage();
            if (message != null && message.getExceptionPayload() == null && replyTo != null) {
                connector.getReplyToHandler(this.endpoint).processReplyTo(RequestContext.getEvent(), message, replyTo);
            }
            return null;
        }
    }
}

