/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.json.transformers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.json.JsonData;
import org.mule.module.json.transformers.AbstractJsonTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonToObject
extends AbstractJsonTransformer {
    private Map<Class, Class> deserializationMixins = new HashMap<Class, Class>();

    public JsonToObject() {
        this.registerSourceType(Reader.class);
        this.registerSourceType(URL.class);
        this.registerSourceType(File.class);
        this.registerSourceType(String.class);
        this.registerSourceType(InputStream.class);
        this.registerSourceType(byte[].class);
        this.setReturnDataType(DataTypeFactory.create(JsonData.class));
    }

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        for (Map.Entry<Class, Class> entry : this.getMixins().entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class, Class> entry : this.deserializationMixins.entrySet()) {
            this.getMapper().getDeserializationConfig().addMixInAnnotations(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        Object src = message.getPayload();
        InputStream is = null;
        try {
            if (src instanceof InputStream) {
                is = (InputStream)src;
            } else if (src instanceof File) {
                is = new FileInputStream((File)src);
            } else if (src instanceof URL) {
                is = ((URL)src).openStream();
            } else if (src instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])src);
            }
            Object returnValue = src instanceof Reader ? (this.getReturnClass().equals(JsonData.class) ? new JsonData((Reader)src) : this.getMapper().readValue((Reader)src, this.getReturnClass())) : (src instanceof String ? (this.getReturnClass().equals(JsonData.class) ? new JsonData((String)src) : this.getMapper().readValue((String)src, this.getReturnClass())) : (this.getReturnClass().equals(JsonData.class) ? new JsonData(is) : this.getMapper().readValue(is, this.getReturnClass())));
            JsonData jsonData = returnValue;
            return jsonData;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("json", this.getReturnClass().getName()), this, (Throwable)e);
        }
        finally {
            if (is != null) {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public Map<Class, Class> getDeserializationMixins() {
        return this.deserializationMixins;
    }

    public void setDeserializationMixins(Map<Class, Class> deserializationMixins) {
        this.deserializationMixins = deserializationMixins;
    }
}

