/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.email;

import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.transport.AbstractMuleMessageFactory;
import org.mule.transport.email.MailUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailMuleMessageFactory
extends AbstractMuleMessageFactory {
    public static final String HEADER_LIST_PREFIX = "List:";
    private static Log log = LogFactory.getLog(MailMuleMessageFactory.class);

    public MailMuleMessageFactory(MuleContext context) {
        super(context);
    }

    protected Class<?>[] getSupportedTransportMessageTypes() {
        return new Class[]{Message.class};
    }

    protected Object extractPayload(Object transportMessage, String encoding) throws Exception {
        return transportMessage;
    }

    protected void addProperties(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        super.addProperties(muleMessage, transportMessage);
        Message mailMessage = (Message)transportMessage;
        muleMessage.setOutboundProperty("inbound.toAddresses", (Object)MailUtils.mailAddressesToString(mailMessage.getRecipients(Message.RecipientType.TO)));
        muleMessage.setOutboundProperty("inbound.ccAddresses", (Object)MailUtils.mailAddressesToString(mailMessage.getRecipients(Message.RecipientType.CC)));
        muleMessage.setOutboundProperty("inbound.bccAddresses", (Object)MailUtils.mailAddressesToString(mailMessage.getRecipients(Message.RecipientType.BCC)));
        try {
            muleMessage.setOutboundProperty("inbound.replyToAddresses", (Object)MailUtils.mailAddressesToString(mailMessage.getReplyTo()));
        }
        catch (MessagingException me) {
            log.warn((Object)"Invalid address found in ReplyTo header:", (Throwable)me);
        }
        try {
            muleMessage.setOutboundProperty("inbound.fromAddress", (Object)MailUtils.mailAddressesToString(mailMessage.getFrom()));
        }
        catch (MessagingException me) {
            log.warn((Object)"Invalid address found in From header:", (Throwable)me);
        }
        muleMessage.setOutboundProperty("inbound.subject", (Object)StringUtils.defaultIfEmpty((String)mailMessage.getSubject(), (String)"(no subject)"));
        muleMessage.setOutboundProperty("inbound.contentType", (Object)StringUtils.defaultIfEmpty((String)mailMessage.getContentType(), (String)"text/plain"));
        Date sentDate = mailMessage.getSentDate();
        if (sentDate == null) {
            sentDate = new Date();
        }
        muleMessage.setOutboundProperty("sentDate", (Object)sentDate);
        Enumeration e = mailMessage.getAllHeaders();
        while (e.hasMoreElements()) {
            LinkedList listPropertyValue;
            Header header = (Header)e.nextElement();
            String name = header.getName();
            String listName = MailUtils.toListHeader(name);
            String value = header.getValue();
            if (null == muleMessage.getOutboundProperty(name)) {
                muleMessage.setOutboundProperty(name, (Object)value);
            }
            if (null == (listPropertyValue = muleMessage.getOutboundProperty(listName))) {
                listPropertyValue = new LinkedList();
                muleMessage.setOutboundProperty(listName, listPropertyValue);
            }
            if (!(listPropertyValue instanceof List)) continue;
            ((List)listPropertyValue).add(header.getValue());
        }
    }

    protected void addAttachments(DefaultMuleMessage muleMessage, Object transportMessage) throws Exception {
        super.addAttachments(muleMessage, transportMessage);
        Object content = ((Message)transportMessage).getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            TreeMap attachments = new TreeMap();
            MailUtils.getAttachments(multipart, attachments);
            log.debug((Object)"Received Multipart message. Adding attachments");
            for (Map.Entry entry : attachments.entrySet()) {
                Part part = (Part)entry.getValue();
                String name = (String)entry.getKey();
                muleMessage.addAttachment(name, part.getDataHandler());
                this.addAttachmentHeaders(name, part, (MuleMessage)muleMessage);
            }
        }
    }

    protected void addAttachmentHeaders(String name, Part part, MuleMessage muleMessage) throws MessagingException {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration e = part.getAllHeaders();
        while (e.hasMoreElements()) {
            Header h = (Header)e.nextElement();
            headers.put(h.getName(), h.getValue());
        }
        if (headers.size() > 0) {
            muleMessage.setOutboundProperty(name + "Headers", headers);
        }
    }
}

