/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.jsr250;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.guiceyfruit.Injectors;
import org.guiceyfruit.support.AnnotationMemberProviderSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMemberProvider
extends AnnotationMemberProviderSupport<Resource> {
    private Injector injector;
    private Context context;

    @Inject
    public ResourceMemberProvider(Injector injector) {
        this.injector = injector;
    }

    public Context getContext() {
        return this.context;
    }

    @Inject(optional=true)
    public void setContext(Context context) {
        this.context = context;
    }

    @Override
    public boolean isNullParameterAllowed(Resource annotation, Method method, Class<?> parameterType, int parameterIndex) {
        return false;
    }

    @Override
    protected Object provide(Resource resource, Member member, TypeLiteral<?> requiredType, Class<?> memberType, Annotation[] annotations) {
        String name = this.getJndiName(resource, member);
        Binding<?> binding = Injectors.getBinding(this.injector, Key.get(requiredType, (Annotation)Names.named((String)name)));
        if (binding != null) {
            return binding.getProvider().get();
        }
        try {
            if (this.context == null) {
                this.context = new InitialContext();
            }
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new ProvisionException("Failed to find name '" + name + "' in JNDI. Cause: " + e, (Throwable)e);
        }
    }

    String getJndiName(Resource resource, Member member) {
        String answer = resource.name();
        if (answer == null || answer.length() == 0) {
            answer = member.getName();
        }
        if (answer == null || answer.length() == 0) {
            throw new IllegalArgumentException("No name defined");
        }
        return answer;
    }
}

