/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.support;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import com.google.inject.internal.Sets;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Names;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.guiceyfruit.Configures;
import org.guiceyfruit.support.AnnotationMemberProvider;
import org.guiceyfruit.support.EncounterProvider;
import org.guiceyfruit.support.MethodHandler;
import org.guiceyfruit.support.Reflectors;
import org.guiceyfruit.support.internal.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GuiceyFruitModule
extends AbstractModule {
    protected void configure() {
        List<Method> configureMethods = this.getConfiguresMethods();
        if (!configureMethods.isEmpty()) {
            final GuiceyFruitModule moduleInstance = this;
            Class<?> moduleType = ((Object)((Object)this)).getClass();
            TypeLiteral type = TypeLiteral.get(moduleType);
            for (final Method method : configureMethods) {
                int size = method.getParameterTypes().length;
                if (size == 0) {
                    throw new ProvisionException("No arguments on @Configures method " + method);
                }
                if (size > 1) {
                    throw new ProvisionException("Too many arguments " + size + " on @Configures method " + method);
                }
                final Class<?> paramType = this.getParameterType(type, method, 0);
                this.bindListener((Matcher)new AbstractMatcher<TypeLiteral<?>>(){

                    public boolean matches(TypeLiteral<?> typeLiteral) {
                        return typeLiteral.getRawType().equals(paramType);
                    }
                }, new TypeListener(){

                    public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                        encounter.register(new MembersInjector<I>(){

                            public void injectMembers(I injectee) {
                                try {
                                    method.setAccessible(true);
                                    method.invoke((Object)moduleInstance, injectee);
                                }
                                catch (IllegalAccessException e) {
                                    throw new ProvisionException("Failed to invoke @Configures method " + method + ". Reason: " + e, (Throwable)e);
                                }
                                catch (InvocationTargetException ie) {
                                    Throwable e = ie.getTargetException();
                                    throw new ProvisionException("Failed to invoke @Configures method " + method + ". Reason: " + e, e);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    private List<Method> getConfiguresMethods() {
        ArrayList answer = Lists.newArrayList();
        List<Method> list = Reflectors.getAllMethods(((Object)((Object)this)).getClass());
        for (Method method : list) {
            if (method.getAnnotation(Configures.class) == null) continue;
            answer.add(method);
        }
        return answer;
    }

    protected <A extends Annotation> void bindMethodHandler(Class<A> annotationType, MethodHandler methodHandler) {
        this.bindMethodHandler(annotationType, EncounterProvider.encounterProvider(methodHandler));
    }

    protected <A extends Annotation> void bindMethodHandler(Class<A> annotationType, Key<? extends MethodHandler> methodHandlerKey) {
        this.bindMethodHandler(annotationType, EncounterProvider.encounterProvider(methodHandlerKey));
    }

    protected <A extends Annotation> void bindMethodHandler(Class<A> annotationType, Class<? extends MethodHandler> methodHandlerType) {
        this.bindMethodHandler(annotationType, EncounterProvider.encounterProvider(methodHandlerType));
    }

    private <A extends Annotation> void bindMethodHandler(final Class<A> annotationType, final EncounterProvider<MethodHandler> encounterProvider) {
        this.bindListener(Matchers.any(), new TypeListener(){

            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                Method[] methods;
                Class type = injectableType.getRawType();
                for (Method method : methods = type.getDeclaredMethods()) {
                    Object annotation = method.getAnnotation(annotationType);
                    if (annotation == null) continue;
                    final Provider provider = encounterProvider.get(encounter);
                    encounter.register(new InjectionListener<I>((Annotation)annotation, method){
                        final /* synthetic */ Annotation val$annotation;
                        final /* synthetic */ Method val$method;
                        {
                            this.val$annotation = annotation;
                            this.val$method = method;
                        }

                        public void afterInjection(I injectee) {
                            MethodHandler methodHandler = (MethodHandler)provider.get();
                            try {
                                methodHandler.afterInjection(injectee, this.val$annotation, this.val$method);
                            }
                            catch (InvocationTargetException ie) {
                                Throwable e = ie.getTargetException();
                                throw new ProvisionException(e.getMessage(), e);
                            }
                            catch (IllegalAccessException e) {
                                throw new ProvisionException(e.getMessage(), (Throwable)e);
                            }
                        }
                    });
                }
            }
        });
    }

    protected <A extends Annotation> void bindAnnotationInjector(Class<A> annotationType, Key<? extends AnnotationMemberProvider> annotationMemberProviderKey) {
        this.bindAnnotationInjector(annotationType, EncounterProvider.encounterProvider(annotationMemberProviderKey));
    }

    protected <A extends Annotation> void bindAnnotationInjector(Class<A> annotationType, AnnotationMemberProvider annotationMemberProvider) {
        this.bindAnnotationInjector(annotationType, EncounterProvider.encounterProvider(annotationMemberProvider));
    }

    protected <A extends Annotation> void bindAnnotationInjector(Class<A> annotationType, Class<? extends AnnotationMemberProvider> annotationMemberProviderType) {
        this.bindAnnotationInjector(annotationType, EncounterProvider.encounterProvider(annotationMemberProviderType));
    }

    private <A extends Annotation> void bindAnnotationInjector(final Class<A> annotationType, final EncounterProvider<AnnotationMemberProvider> memberProviderProvider) {
        this.bindListener(Matchers.any(), new TypeListener(){
            Provider<? extends AnnotationMemberProvider> providerProvider;

            public <I> void hear(TypeLiteral<I> injectableType, TypeEncounter<I> encounter) {
                Class type;
                HashSet boundFields = Sets.newHashSet();
                HashMap boundMethods = Maps.newHashMap();
                TypeLiteral startType = injectableType;
                while ((type = startType.getRawType()) != Object.class) {
                    Method[] methods;
                    Field[] fields;
                    for (Field field : fields = type.getDeclaredFields()) {
                        if (!boundFields.add(field)) continue;
                        this.bindAnnotationInjectorToField(encounter, startType, field);
                    }
                    for (Method method : methods = type.getDeclaredMethods()) {
                        MethodKey key = new MethodKey(method);
                        if (boundMethods.get(key) != null) continue;
                        boundMethods.put(key, method);
                        this.bindAnnotationInjectionToMember(encounter, startType, method);
                    }
                    Class supertype = type.getSuperclass();
                    if (supertype == Object.class) break;
                    startType = startType.getSupertype(supertype);
                }
            }

            protected <I> void bindAnnotationInjectionToMember(TypeEncounter<I> encounter, TypeLiteral<?> type, final Method method) {
                Object annotation = method.getAnnotation(annotationType);
                if (annotation != null) {
                    if (this.providerProvider == null) {
                        this.providerProvider = memberProviderProvider.get(encounter);
                    }
                    encounter.register(new MembersInjector<I>((TypeLiteral)type, (Annotation)annotation, (TypeEncounter)encounter){
                        final /* synthetic */ TypeLiteral val$type;
                        final /* synthetic */ Annotation val$annotation;
                        final /* synthetic */ TypeEncounter val$encounter;
                        {
                            this.val$type = typeLiteral;
                            this.val$annotation = annotation;
                            this.val$encounter = typeEncounter;
                        }

                        public void injectMembers(I injectee) {
                            AnnotationMemberProvider provider = (AnnotationMemberProvider)providerProvider.get();
                            int size = method.getParameterTypes().length;
                            Object[] values = new Object[size];
                            for (int i = 0; i < size; ++i) {
                                Class<?> paramType = GuiceyFruitModule.this.getParameterType(this.val$type, method, i);
                                Object value = provider.provide(this.val$annotation, this.val$type, method, paramType, i);
                                GuiceyFruitModule.this.checkInjectedValueType(value, paramType, this.val$encounter);
                                if (value == null && !provider.isNullParameterAllowed(this.val$annotation, method, paramType, i)) {
                                    return;
                                }
                                values[i] = value;
                            }
                            try {
                                method.setAccessible(true);
                                method.invoke(injectee, values);
                            }
                            catch (IllegalAccessException e) {
                                throw new ProvisionException("Failed to inject method " + method + ". Reason: " + e, (Throwable)e);
                            }
                            catch (InvocationTargetException ie) {
                                Throwable e = ie.getTargetException();
                                throw new ProvisionException("Failed to inject method " + method + ". Reason: " + e, e);
                            }
                        }
                    });
                }
            }

            protected <I> void bindAnnotationInjectorToField(TypeEncounter<I> encounter, TypeLiteral<?> type, Field field) {
                Object annotation = field.getAnnotation(annotationType);
                if (annotation != null) {
                    if (this.providerProvider == null) {
                        this.providerProvider = memberProviderProvider.get(encounter);
                    }
                    encounter.register(new InjectionListener<I>((Annotation)annotation, (TypeLiteral)type, field, (TypeEncounter)encounter){
                        final /* synthetic */ Annotation val$annotation;
                        final /* synthetic */ TypeLiteral val$type;
                        final /* synthetic */ Field val$field;
                        final /* synthetic */ TypeEncounter val$encounter;
                        {
                            this.val$annotation = annotation;
                            this.val$type = typeLiteral;
                            this.val$field = field;
                            this.val$encounter = typeEncounter;
                        }

                        public void afterInjection(I injectee) {
                            AnnotationMemberProvider provider = (AnnotationMemberProvider)providerProvider.get();
                            Object value = provider.provide(this.val$annotation, this.val$type, this.val$field);
                            GuiceyFruitModule.this.checkInjectedValueType(value, this.val$field.getType(), this.val$encounter);
                            try {
                                this.val$field.setAccessible(true);
                                this.val$field.set(injectee, value);
                            }
                            catch (IllegalAccessException e) {
                                throw new ProvisionException("Failed to inject field " + this.val$field + ". Reason: " + e, (Throwable)e);
                            }
                        }
                    });
                }
            }
        });
    }

    protected Class<?> getParameterType(TypeLiteral<?> type, Method method, int i) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        List list = type.getParameterTypes((Member)method);
        TypeLiteral typeLiteral = (TypeLiteral)list.get(i);
        Class<?> paramType = typeLiteral.getRawType();
        if (paramType == Object.class || paramType.isArray() && paramType.getComponentType() == Object.class) {
            paramType = parameterTypes[i];
        }
        return paramType;
    }

    protected <I> void checkInjectedValueType(Object value, Class<?> type, TypeEncounter<I> encounter) {
    }

    protected <T> LinkedBindingBuilder<T> bind(Class<T> type, Class<? extends Annotation> annotationType) {
        return this.bind(Key.get(type, annotationType));
    }

    protected <T> LinkedBindingBuilder<T> bind(Class<T> type, Annotation annotation) {
        return this.bind(Key.get(type, (Annotation)annotation));
    }

    protected <T> LinkedBindingBuilder<T> bind(Class<T> type, String namedText) {
        return this.bind(type, (Annotation)Names.named((String)namedText));
    }

    protected <T> void bindInstance(String name, T instance) {
        Class<?> aClass = instance.getClass();
        this.bind(aClass, name).toInstance(instance);
    }
}

