/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.support;

import com.google.inject.TypeLiteral;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.guiceyfruit.support.internal.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflectors {
    public static List<Method> getAllMethods(Class<?> type) {
        return Reflectors.getAllMethods(TypeLiteral.get(type));
    }

    public static List<Method> getAllMethods(TypeLiteral<?> startType) {
        Class type;
        ArrayList answer = Lists.newArrayList();
        HashMap boundMethods = Maps.newHashMap();
        while ((type = startType.getRawType()) != Object.class) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                MethodKey key = new MethodKey(method);
                if (boundMethods.get(key) != null) continue;
                boundMethods.put(key, method);
                answer.add(method);
            }
            Class supertype = type.getSuperclass();
            if (supertype == Object.class) break;
            startType = startType.getSupertype(supertype);
        }
        return answer;
    }
}

