/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.support.internal;

import com.google.inject.CreationException;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.ImmutableList;
import com.google.inject.internal.Lists;
import com.google.inject.internal.MatcherAndConverter;
import com.google.inject.internal.MoreTypes;
import com.google.inject.internal.Preconditions;
import com.google.inject.internal.SourceProvider;
import com.google.inject.internal.StackTraceElements;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import org.guiceyfruit.support.internal.ErrorsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Errors
implements Serializable {
    private static final boolean allowNullsBadBadBad = "I'm a bad hack".equals(System.getProperty("guice.allow.nulls.bad.bad.bad"));
    private List<Message> errors;
    private final List<Object> sources;
    private static final String CONSTRUCTOR_RULES = "Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.";
    private static final Collection<Converter<?>> converters = ImmutableList.of((Object)new Converter<MatcherAndConverter>(MatcherAndConverter.class){

        @Override
        public String toString(MatcherAndConverter m) {
            return m.toString();
        }
    }, (Object)new Converter<Class>(Class.class){

        @Override
        public String toString(Class c) {
            return c.getName();
        }
    }, (Object)new Converter<Member>(Member.class){

        @Override
        public String toString(Member member) {
            return MoreTypes.toString((Member)member);
        }
    }, (Object)new Converter<Key>(Key.class){

        @Override
        public String toString(Key k) {
            StringBuilder result = new StringBuilder();
            result.append(k.getTypeLiteral());
            if (k.getAnnotationType() != null) {
                result.append(" annotated with ");
                result.append(k.getAnnotation() != null ? k.getAnnotation() : k.getAnnotationType());
            }
            return result.toString();
        }
    });

    public Errors() {
        this.sources = Lists.newArrayList();
        this.errors = Lists.newArrayList();
    }

    public Errors(Object source) {
        this.sources = Lists.newArrayList((Object[])new Object[]{source});
        this.errors = Lists.newArrayList();
    }

    private Errors(Errors parent, Object source) {
        this.errors = parent.errors;
        this.sources = Lists.newArrayList(parent.sources);
        this.sources.add(source);
    }

    public Errors withSource(Object source) {
        return source == SourceProvider.UNKNOWN_SOURCE ? this : new Errors(this, source);
    }

    public void pushSource(Object source) {
        this.sources.add(source);
    }

    public void popSource(Object source) {
        Object popped = this.sources.remove(this.sources.size() - 1);
        Preconditions.checkArgument((source == popped ? 1 : 0) != 0);
    }

    public Errors missingImplementation(Object keyOrType) {
        return this.addMessage("No implementation for %s was bound.", keyOrType);
    }

    public Errors converterReturnedNull(String stringValue, Object source, TypeLiteral<?> type, MatcherAndConverter matchingConverter) {
        return this.addMessage("Received null converting '%s' (bound at %s) to %s%n using %s.", stringValue, source, type, matchingConverter);
    }

    public Errors conversionTypeError(String stringValue, Object source, TypeLiteral<?> type, MatcherAndConverter matchingConverter, Object converted) {
        return this.addMessage("Type mismatch converting '%s' (bound at %s) to %s%n using %s.%n Converter returned %s.", stringValue, source, type, matchingConverter, converted);
    }

    public Errors conversionError(String stringValue, Object source, TypeLiteral<?> type, MatcherAndConverter matchingConverter, Exception cause) {
        return this.addMessage(cause, "Error converting '%s' (bound at %s) to %s%n using %s.%n Reason: %s", stringValue, source, type, matchingConverter, cause);
    }

    public Errors ambiguousTypeConversion(String stringValue, Object source, TypeLiteral<?> type, MatcherAndConverter a, MatcherAndConverter b) {
        return this.addMessage("Multiple converters can convert '%s' (bound at %s) to %s:%n %s and%n %s.%n Please adjust your type converter configuration to avoid overlapping matches.", stringValue, source, type, a, b);
    }

    public Errors bindingToProvider() {
        return this.addMessage("Binding to Provider is not allowed.", new Object[0]);
    }

    public Errors subtypeNotProvided(Class<? extends Provider<?>> providerType, Class<?> type) {
        return this.addMessage("%s doesn't provide instances of %s.", providerType, type);
    }

    public Errors notASubtype(Class<?> implementationType, Class<?> type) {
        return this.addMessage("%s doesn't extend %s.", implementationType, type);
    }

    public Errors recursiveImplementationType() {
        return this.addMessage("@ImplementedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors recursiveProviderType() {
        return this.addMessage("@ProvidedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors missingRuntimeRetention(Object source) {
        return this.addMessage("Please annotate with @Retention(RUNTIME).%n Bound at %s.", source);
    }

    public Errors missingScopeAnnotation() {
        return this.addMessage("Please annotate with @ScopeAnnotation.", new Object[0]);
    }

    public Errors optionalConstructor(Constructor constructor) {
        return this.addMessage("%s is annotated @Inject(optional=true), but constructors cannot be optional.", constructor);
    }

    public Errors cannotBindToGuiceType(String simpleName) {
        return this.addMessage("Binding to core guice framework type is not allowed: %s.", simpleName);
    }

    public Errors scopeNotFound(Class<? extends Annotation> scopeAnnotation) {
        return this.addMessage("No scope is bound to %s.", scopeAnnotation);
    }

    public Errors scopeAnnotationOnAbstractType(Class<? extends Annotation> scopeAnnotation, Class<?> type, Object source) {
        return this.addMessage("%s is annotated with %s, but scope annotations are not supported for abstract types.%n Bound at %s.", type, scopeAnnotation, source);
    }

    public Errors misplacedBindingAnnotation(Member member, Annotation bindingAnnotation) {
        return this.addMessage("%s is annotated with %s, but binding annotations should be applied to its parameters instead.", member, bindingAnnotation);
    }

    public Errors missingConstructor(Class<?> implementation) {
        return this.addMessage("Could not find a suitable constructor in %s. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation);
    }

    public Errors tooManyConstructors(Class<?> implementation) {
        return this.addMessage("%s has more than one constructor annotated with @Inject. Classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.", implementation);
    }

    public Errors duplicateScopes(Scope existing, Class<? extends Annotation> annotationType, Scope scope) {
        return this.addMessage("Scope %s is already bound to %s. Cannot bind %s.", existing, annotationType, scope);
    }

    public Errors missingConstantValues() {
        return this.addMessage("Missing constant value. Please call to(...).", new Object[0]);
    }

    public Errors cannotInjectInnerClass(Class<?> type) {
        return this.addMessage("Injecting into inner classes is not supported.  Please use a 'static' class (top-level or nested) instead of %s.", type);
    }

    public Errors duplicateBindingAnnotations(Member member, Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("%s has more than one annotation annotated with @BindingAnnotation: %s and %s", member, a, b);
    }

    public Errors duplicateScopeAnnotations(Class<? extends Annotation> a, Class<? extends Annotation> b) {
        return this.addMessage("More than one scope annotation was found: %s and %s", a, b);
    }

    public Errors recursiveBinding() {
        return this.addMessage("Binding points to itself.", new Object[0]);
    }

    public Errors bindingAlreadySet(Key<?> key, Object source) {
        return this.addMessage("A binding to %s was already configured at %s.", key, source);
    }

    public Errors childBindingAlreadySet(Key<?> key) {
        return this.addMessage("A binding to %s already exists on a child injector.", key);
    }

    public Errors errorInjectingMethod(Throwable cause) {
        return this.addMessage(cause, "Error injecting method, %s", cause);
    }

    public Errors errorInjectingConstructor(Throwable cause) {
        return this.addMessage(cause, "Error injecting constructor, %s", cause);
    }

    public Errors errorInProvider(RuntimeException runtimeException, Errors errorsFromException) {
        if (errorsFromException != null) {
            return this.merge(errorsFromException);
        }
        return this.addMessage(runtimeException, "Error in custom provider, %s", runtimeException);
    }

    public Errors cannotInjectRawProvider() {
        return this.addMessage("Cannot inject a Provider that has no type parameter", new Object[0]);
    }

    public Errors cannotSatisfyCircularDependency(Class<?> expectedType) {
        return this.addMessage("Tried proxying %s to support a circular dependency, but it is not an interface.", expectedType);
    }

    public Errors makeImmutable() {
        this.errors = ImmutableList.copyOf(this.errors);
        return this;
    }

    public void throwCreationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        this.makeImmutable();
        throw new CreationException(this.getMessages());
    }

    private Message merge(Message message) {
        ArrayList sources = Lists.newArrayList();
        sources.addAll(this.sources);
        sources.addAll(message.getSources());
        return new Message(this.stripDuplicates(sources), message.getMessage(), message.getCause());
    }

    public Errors merge(Collection<Message> messages) {
        if (messages != this.errors) {
            for (Message message : messages) {
                this.errors.add(this.merge(message));
            }
        }
        return this;
    }

    public Errors merge(Errors moreErrors) {
        this.merge(moreErrors.errors);
        return this;
    }

    public void throwIfNecessary() throws ErrorsException {
        if (!this.hasErrors()) {
            return;
        }
        throw this.toException();
    }

    public ErrorsException toException() {
        return new ErrorsException(this);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private Errors addMessage(String messageFormat, Object ... arguments) {
        return this.addMessage(null, messageFormat, arguments);
    }

    public Errors addMessage(Throwable cause, String messageFormat, Object ... arguments) {
        String message = this.format(messageFormat, arguments);
        this.addMessage(new Message(this.stripDuplicates(this.sources), message, cause));
        return this;
    }

    public Errors addMessage(Message message) {
        this.errors.add(message);
        return this;
    }

    private String format(String messageFormat, Object ... arguments) {
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = Errors.convert(arguments[i]);
        }
        return String.format(messageFormat, arguments);
    }

    public List<Message> getMessages() {
        ArrayList result = Lists.newArrayList(this.errors);
        Collections.sort(result, new Comparator<Message>(){

            @Override
            public int compare(Message a, Message b) {
                return a.getSource().compareTo(b.getSource());
            }
        });
        return result;
    }

    public static String format(String heading, Collection<? extends Message> errorMessages) {
        Formatter fmt = new Formatter().format(heading, new Object[0]).format(":%n%n", new Object[0]);
        int index = 1;
        for (Message message : errorMessages) {
            fmt.format("%s) %s%n", index++, message.getMessage());
            List dependencies = message.getSources();
            for (int i = dependencies.size() - 1; i >= 0; --i) {
                Object source = dependencies.get(i);
                if (source instanceof Dependency) {
                    Dependency dependency = (Dependency)source;
                    InjectionPoint injectionPoint = dependency.getInjectionPoint();
                    if (injectionPoint == null) continue;
                    Member member = injectionPoint.getMember();
                    Class memberType = MoreTypes.memberType((Member)member);
                    if (memberType == Field.class) {
                        fmt.format("  for field at %s%n", StackTraceElements.forMember((Member)member));
                        continue;
                    }
                    if (memberType == Method.class || memberType == Constructor.class) {
                        fmt.format("  for parameter %s at %s%n", dependency.getParameterIndex(), StackTraceElements.forMember((Member)member));
                        continue;
                    }
                    throw new AssertionError();
                }
                fmt.format("  at %s%n", Errors.sourceToString(source));
            }
            fmt.format("%n", new Object[0]);
        }
        return fmt.format("%s error[s]", errorMessages.size()).toString();
    }

    public <T> T checkForNull(T value, Object source, Dependency<?> dependency) throws ErrorsException {
        if (value != null || dependency.isNullable() || allowNullsBadBadBad) {
            return value;
        }
        int parameterIndex = dependency.getParameterIndex();
        String parameterName = parameterIndex != -1 ? "parameter " + parameterIndex + " of " : "";
        this.addMessage("null returned by binding at %s%n but %s%s is not @Nullable", source, parameterName, dependency.getInjectionPoint().getMember());
        throw this.toException();
    }

    public static Object convert(Object o) {
        for (Converter<?> converter : converters) {
            if (!converter.appliesTo(o)) continue;
            return converter.convert(o);
        }
        return o;
    }

    public static String sourceToString(Object source) {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        if (source instanceof InjectionPoint) {
            return Errors.sourceToString(((InjectionPoint)source).getMember());
        }
        if (source instanceof Member) {
            return StackTraceElements.forMember((Member)((Member)source)).toString();
        }
        if (source instanceof Class) {
            return StackTraceElements.forType((Class)((Class)source)).toString();
        }
        return Errors.convert(source).toString();
    }

    private <T> List<T> stripDuplicates(List<T> list) {
        Iterator i = (list = Lists.newArrayList(list)).iterator();
        if (i.hasNext()) {
            Object last = i.next();
            while (i.hasNext()) {
                Object current = i.next();
                if (last.equals(current)) {
                    i.remove();
                }
                last = current;
            }
        }
        return ImmutableList.copyOf((Iterable)list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Converter<T> {
        final Class<T> type;

        Converter(Class<T> type) {
            this.type = type;
        }

        boolean appliesTo(Object o) {
            return this.type.isAssignableFrom(o.getClass());
        }

        String convert(Object o) {
            return this.toString(this.type.cast(o));
        }

        abstract String toString(T var1);
    }
}

