/*
 * Decompiled with CFR 0.152.
 */
package org.guiceyfruit.testing;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.internal.Preconditions;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.guiceyfruit.Injectors;
import org.guiceyfruit.support.CloseFailedException;
import org.guiceyfruit.support.internal.CloseErrorsImpl;
import org.guiceyfruit.testing.ClassScoped;
import org.guiceyfruit.testing.TestScoped;
import org.guiceyfruit.testing.UseModule;
import org.guiceyfruit.util.CloseableScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorManager {
    private Map<Object, Injector> injectors = new ConcurrentHashMap<Object, Injector>();
    private AtomicInteger initializeCounter = new AtomicInteger(0);
    private CloseableScope testScope = new CloseableScope(TestScoped.class);
    private CloseableScope classScope = new CloseableScope(ClassScoped.class);
    private static final String NESTED_MODULE_CLASS = "TestModule";
    private boolean closeSingletonsAfterClasses = false;
    private boolean runFinalizer = true;
    private Injector lastClassInjector;
    private Class<? extends Module> moduleType;

    public void beforeClasses() {
        int counter = this.initializeCounter.incrementAndGet();
        if (counter <= 1 && this.runFinalizer) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        InjectorManager.this.closeSingletons();
                    }
                    catch (Throwable e) {
                        System.out.println("Failed to shut down Guice Singletons: " + e);
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public void afterClasses() throws CloseFailedException {
        Injector injector = this.injectors.get(this.moduleType);
        if (injector != null) {
            this.classScope.close(injector);
        } else {
            System.out.println("Could not close Class scope as there is no Injector for module type " + injector);
        }
        if (this.isCloseSingletonsAfterClasses()) {
            this.closeInjectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTest(Object test) throws Exception {
        Injector classInjector;
        Preconditions.checkNotNull((Object)test, (Object)"test");
        Class<?> testType = test.getClass();
        this.moduleType = this.getModuleForTestClass(testType);
        Map<Object, Injector> map = this.injectors;
        synchronized (map) {
            classInjector = this.injectors.get(this.moduleType);
            if (classInjector == null) {
                classInjector = this.createInjector(this.moduleType);
                Preconditions.checkNotNull((Object)classInjector, (Object)"classInjector");
                this.injectors.put(this.moduleType, classInjector);
            }
        }
        this.injectors.put(testType, classInjector);
        classInjector.injectMembers(test);
    }

    public void afterTest(Object test) throws Exception {
        Injector injector = this.injectors.get(test.getClass());
        if (injector == null) {
            System.out.println("Warning - no injector available for: " + test);
        } else {
            this.lastClassInjector = injector;
            this.testScope.close(injector);
        }
    }

    public void closeSingletons() throws CloseFailedException {
        this.closeInjectors();
    }

    public boolean isCloseSingletonsAfterClasses() {
        return this.closeSingletonsAfterClasses;
    }

    public void setCloseSingletonsAfterClasses(boolean closeSingletonsAfterClasses) {
        this.closeSingletonsAfterClasses = closeSingletonsAfterClasses;
    }

    protected void closeInjectors() throws CloseFailedException {
        CloseErrorsImpl errors = new CloseErrorsImpl(this);
        Set<Map.Entry<Object, Injector>> entries = this.injectors.entrySet();
        for (Map.Entry<Object, Injector> entry : entries) {
            Injector injector = entry.getValue();
            Injectors.close(injector, errors);
        }
        this.injectors.clear();
        errors.throwIfNecessary();
    }

    protected Class<? extends Module> getModuleForTestClass(Class<?> objectType) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<Object> moduleType;
        String modules = System.getProperty("org.guiceyfruit.modules");
        if (modules != null && (modules = modules.trim()).length() > 0) {
            System.out.println("Overloading Guice Modules: " + modules);
            return null;
        }
        UseModule config = objectType.getAnnotation(UseModule.class);
        if (config != null) {
            moduleType = config.value();
        } else {
            Class<?> type;
            String name = objectType.getName() + "$" + NESTED_MODULE_CLASS;
            try {
                type = objectType.getClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                try {
                    type = Thread.currentThread().getContextClassLoader().loadClass(name);
                }
                catch (ClassNotFoundException e2) {
                    throw new ClassNotFoundException("Class " + objectType.getName() + " does not have a @UseModule annotation nor does it have a nested class called " + NESTED_MODULE_CLASS + " available on the classpath. Please see: http://code.google.com/p/guiceyfruit/wiki/Testing" + e, e);
                }
            }
            try {
                moduleType = type;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Class " + type.getName() + " is not a Guice Module!", e);
            }
        }
        int modifiers = moduleType.getModifiers();
        if (Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new IllegalArgumentException("Class " + moduleType.getName() + " must be a public class which is non abstract");
        }
        try {
            moduleType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + moduleType.getName() + " must have a zero argument constructor", e);
        }
        return moduleType;
    }

    protected Injector createInjector(Class<? extends Module> moduleType) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (moduleType == null) {
            return Injectors.createInjector(System.getProperties(), new Module[]{new TestModule()});
        }
        Module module = moduleType.newInstance();
        return Guice.createInjector((Module[])new Module[]{module, new TestModule()});
    }

    protected class TestModule
    extends AbstractModule {
        protected TestModule() {
        }

        protected void configure() {
            this.bindScope(ClassScoped.class, InjectorManager.this.classScope);
            this.bindScope(TestScoped.class, InjectorManager.this.testScope);
        }
    }
}

