/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.ExtendedKeyStoreSpi;
import cryptix.pki.KeyBundle;
import cryptix.pki.Support;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class ExtendedKeyStore
extends KeyStore {
    private final ExtendedKeyStoreSpi spi;

    protected ExtendedKeyStore(ExtendedKeyStoreSpi storeSpi, Provider provider, String type) {
        super(storeSpi, provider, type);
        this.spi = storeSpi;
    }

    public static KeyStore getInstance(String type) throws KeyStoreException {
        try {
            Object[] o = Support.getImplementation("ExtendedKeyStore", type);
            return new ExtendedKeyStore((ExtendedKeyStoreSpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyStoreException(String.valueOf(String.valueOf(nsae)));
        }
    }

    public static KeyStore getInstance(String type, String provider) throws KeyStoreException {
        try {
            Object[] o = Support.getImplementation("ExtendedKeyStore", type, provider);
            return new ExtendedKeyStore((ExtendedKeyStoreSpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyStoreException(String.valueOf(String.valueOf(nsae)));
        }
        catch (NoSuchProviderException nspe) {
            throw new KeyStoreException(String.valueOf(String.valueOf(nspe)));
        }
    }

    public static KeyStore getInstance(String type, Provider provider) throws KeyStoreException {
        try {
            Object[] o = Support.getImplementation("ExtendedKeyStore", type, provider);
            return new ExtendedKeyStore((ExtendedKeyStoreSpi)o[0], (Provider)o[1], type);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyStoreException(String.valueOf(String.valueOf(nsae)));
        }
    }

    public final KeyBundle getKeyBundle(String alias) throws KeyStoreException {
        return this.spi.engineGetKeyBundle(alias);
    }

    public final boolean isKeyBundleEntry(String alias) throws KeyStoreException {
        return this.spi.engineIsKeyBundleEntry(alias);
    }

    public final String setKeyBundleEntry(KeyBundle bundle) throws KeyStoreException {
        return this.spi.engineSetKeyBundleEntry(bundle);
    }
}

