/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.jobexecutor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jbpm.api.JbpmException;
import org.jbpm.api.cmd.Command;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.cmd.CommandService;
import org.jbpm.pvm.internal.jobexecutor.AcquireJobsCmd;
import org.jbpm.pvm.internal.jobexecutor.DispatcherThread;
import org.jbpm.pvm.internal.jobexecutor.GetNextDueDateCmd;
import org.jbpm.pvm.internal.jobexecutor.JobHistoryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExecutor
implements Serializable {
    private static final Log log = Log.getLog((String)JobExecutor.class.getName());
    private static final long serialVersionUID = 1L;
    CommandService commandService;
    String name = "JobExecutor-" + JobExecutor.getHostName();
    int nbrOfThreads = 3;
    int idleMillis = 5000;
    int idleMillisMax = 300000;
    int historySize = 200;
    int lockMillis = 1800000;
    Command<Collection<Long>> acquireJobsCommand;
    Command<Date> nextDueDateCommand;
    boolean isActive;
    ExecutorService threadPool;
    DispatcherThread dispatcherThread;
    List<JobHistoryEntry> history = new ArrayList<JobHistoryEntry>();

    public synchronized void start() {
        if (this.commandService == null) {
            throw new JbpmException("no command executor available in job executor");
        }
        if (!this.isActive) {
            this.acquireJobsCommand = new AcquireJobsCmd(this);
            this.nextDueDateCommand = new GetNextDueDateCmd(this);
            this.isActive = true;
            log.trace("starting thread pool for job executor '" + this.name + "'...");
            this.threadPool = new ThreadPoolExecutor(this.nbrOfThreads, this.nbrOfThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.nbrOfThreads), JobRejectionHandler.INSTANCE);
            log.trace("starting dispatcher thread for job executor '" + this.name + "'...");
            this.dispatcherThread = new DispatcherThread(this);
            this.dispatcherThread.start();
        } else {
            log.trace("ignoring start: job executor '" + this.name + "' is already started'");
        }
    }

    public synchronized void stop() {
        this.stop(false);
    }

    public synchronized void stop(boolean join) {
        log.debug("stopping job executor");
        if (this.isActive) {
            this.isActive = false;
            this.dispatcherThread.deactivate(true);
            this.threadPool.shutdown();
            if (join) {
                try {
                    this.threadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    log.trace("joining " + this.getName() + " got interrupted");
                }
            }
        } else {
            log.trace("ignoring stop: job executor '" + this.name + "' not started");
        }
    }

    public void jobWasAdded() {
        if (this.dispatcherThread != null && this.dispatcherThread.isActive()) {
            this.dispatcherThread.jobWasAdded();
        }
    }

    static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public String getName() {
        return this.name;
    }

    public int getHistorySize() {
        return this.historySize;
    }

    public int getIdleMillis() {
        return this.idleMillis;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public int getIdleMillisMax() {
        return this.idleMillisMax;
    }

    public int getLockMillis() {
        return this.lockMillis;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public CommandService getCommandExecutor() {
        return this.commandService;
    }

    public Command<Collection<Long>> getAcquireJobsCommand() {
        return this.acquireJobsCommand;
    }

    public Command<Date> getNextDueDateCommand() {
        return this.nextDueDateCommand;
    }

    public DispatcherThread getDispatcherThread() {
        return this.dispatcherThread;
    }

    public List<JobHistoryEntry> getHistory() {
        return this.history;
    }

    public void setCommandExecutor(CommandService commandService) {
        this.commandService = commandService;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNbrOfJobExecutorThreads(int nbrOfJobExecutorThreads) {
        this.nbrOfThreads = nbrOfJobExecutorThreads;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleMillis = idleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.idleMillisMax = maxIdleInterval;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historySize = historyMaxSize;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.lockMillis = maxLockTime;
    }

    static final class JobRejectionHandler
    implements RejectedExecutionHandler {
        static final JobRejectionHandler INSTANCE = new JobRejectionHandler();

        JobRejectionHandler() {
        }

        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(task);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("queuing " + task + " got interrupted", e);
            }
        }
    }
}

