/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.model.op;

import java.util.Map;
import org.jbpm.api.JbpmException;
import org.jbpm.api.activity.ActivityExecution;
import org.jbpm.api.activity.ExternalActivityBehaviour;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.job.MessageImpl;
import org.jbpm.pvm.internal.model.ActivityImpl;
import org.jbpm.pvm.internal.model.ExecutionImpl;
import org.jbpm.pvm.internal.model.op.AtomicOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signal
extends AtomicOperation {
    private static final long serialVersionUID = 1L;
    private static final Log log = Log.getLog((String)Signal.class.getName());
    String signalName;
    Map<String, ?> parameters;

    public Signal(String signalName, Map<String, ?> parameters) {
        this.signalName = signalName;
        this.parameters = parameters;
    }

    @Override
    public boolean isAsync(ExecutionImpl execution) {
        return false;
    }

    @Override
    public void perform(ExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (execution.getName() != null) {
            log.debug(execution.toString() + " signals " + activity);
        } else {
            log.debug("signalling " + activity + ", signalName=" + this.signalName);
        }
        ExternalActivityBehaviour externalActivityBehaviour = (ExternalActivityBehaviour)activity.getActivityBehaviour();
        try {
            execution.setPropagation(ExecutionImpl.Propagation.UNSPECIFIED);
            externalActivityBehaviour.signal((ActivityExecution)execution, this.signalName, this.parameters);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't signal " + activity + ": " + e.getMessage(), (Throwable)e);
        }
        if (execution.getPropagation() == ExecutionImpl.Propagation.UNSPECIFIED) {
            execution.proceed();
        }
    }

    public String toString() {
        return "Signal";
    }

    @Override
    public MessageImpl<?> createAsyncMessage(ExecutionImpl execution) {
        return null;
    }
}

