/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.pvm.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jbpm.api.JbpmException;
import org.jbpm.internal.log.Log;
import org.jbpm.pvm.internal.env.EnvironmentImpl;
import org.jbpm.pvm.internal.model.ProcessDefinitionImpl;
import org.jbpm.pvm.internal.repository.DeploymentClassLoader;
import org.jbpm.pvm.internal.repository.RepositoryCache;
import org.jbpm.pvm.internal.wire.Descriptor;
import org.jbpm.pvm.internal.wire.WireContext;
import org.jbpm.pvm.internal.wire.descriptor.ArgDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectUtil {
    private static Log log = Log.getLog((String)ReflectUtil.class.getName());

    public static Field findField(Class<?> clazz, String fieldName) {
        return ReflectUtil.findField(clazz, fieldName, clazz);
    }

    private static Field findField(Class<?> clazz, String fieldName, Class<?> original) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldName);
            if (log.isTraceEnabled()) {
                log.trace("found field " + fieldName + " in " + clazz.getName());
            }
        }
        catch (SecurityException e) {
            throw new JbpmException("wasn't allowed to get field '" + clazz.getName() + "." + fieldName + "'", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.findField(clazz.getSuperclass(), fieldName, original);
            }
            throw new JbpmException("couldn't find field '" + original.getName() + "." + fieldName + "'", (Throwable)e);
        }
        return field;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes) {
        return ReflectUtil.getMethod(clazz, methodName, parameterTypes, clazz);
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Class<?> original) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (log.isTraceEnabled()) {
                log.trace("found method " + clazz.getName() + "." + methodName + "(" + Arrays.toString(parameterTypes) + ")");
            }
        }
        catch (SecurityException e) {
            throw new JbpmException("wasn't allowed to get method '" + clazz.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null) {
                return ReflectUtil.getMethod(clazz.getSuperclass(), methodName, parameterTypes, original);
            }
            throw new JbpmException("couldn't find method '" + original.getName() + "." + methodName + "(" + ReflectUtil.getParameterTypesText(parameterTypes) + ")'", (Throwable)e);
        }
        return method;
    }

    private static String getParameterTypesText(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            return "";
        }
        StringBuilder parameterTypesText = new StringBuilder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            parameterTypesText.append(parameterType.getName());
            if (i == parameterTypes.length - 1) continue;
            parameterTypesText.append(", ");
        }
        return parameterTypesText.toString();
    }

    public static <T> T newInstance(Class<T> clazz) {
        return ReflectUtil.newInstance(clazz, null, null);
    }

    public static <T> T newInstance(Constructor<T> constructor) {
        return ReflectUtil.newInstance(null, constructor, null);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object[] args) {
        return ReflectUtil.newInstance(null, constructor, args);
    }

    private static <T> T newInstance(Class<T> clazz, Constructor<T> constructor, Object[] args) {
        if (clazz == null && constructor == null) {
            throw new IllegalArgumentException("can't create new instance without clazz or constructor");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("creating new instance for class '" + clazz.getName() + "' with args " + Arrays.toString(args));
            }
            if (constructor == null) {
                if (log.isTraceEnabled()) {
                    log.trace("getting default constructor");
                }
                constructor = clazz.getConstructor(null);
            }
            if (!constructor.isAccessible()) {
                if (log.isTraceEnabled()) {
                    log.trace("making constructor accessible");
                }
                constructor.setAccessible(true);
            }
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new JbpmException("couldn't construct new '" + clazz.getName() + "' with args " + Arrays.toString(args), t);
        }
    }

    public static Object get(Field field, Object object) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            Object value = field.get(object);
            if (log.isTraceEnabled()) {
                log.trace("got value '" + value + "' from field '" + field.getName() + "'");
            }
            return value;
        }
        catch (Exception e) {
            throw new JbpmException("couldn't get '" + field.getName() + "'", (Throwable)e);
        }
    }

    public static void set(Field field, Object object, Object value) {
        if (field == null) {
            throw new NullPointerException("field is null");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("setting field '" + field.getName() + "' to value '" + value + "'");
            }
            if (!field.isAccessible()) {
                if (log.isTraceEnabled()) {
                    log.trace("making field accessible");
                }
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't set '" + field.getName() + "' to '" + value + "'", (Throwable)e);
        }
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        if (method == null) {
            throw new JbpmException("method is null");
        }
        try {
            if (log.isTraceEnabled()) {
                log.trace("invoking '" + method.getName() + "' on '" + target + "' with " + Arrays.toString(args));
            }
            if (!method.isAccessible()) {
                log.trace("making method accessible");
                method.setAccessible(true);
            }
            return method.invoke(target, args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new JbpmException("couldn't invoke '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + targetException.getMessage(), targetException);
        }
        catch (Exception e) {
            throw new JbpmException("couldn't invoke '" + method.getName() + "' with " + Arrays.toString(args) + " on " + target + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public static Method findMethod(Class<?> clazz, String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        if (log.isTraceEnabled()) {
            log.trace("searching for method " + methodName + " in " + clazz.getName());
        }
        Method[] candidates = clazz.getDeclaredMethods();
        for (int i = 0; i < candidates.length; ++i) {
            Method candidate = candidates[i];
            if (!candidate.getName().equals(methodName) || !ReflectUtil.isArgumentMatch(candidate.getParameterTypes(), argDescriptors, args)) continue;
            if (log.isTraceEnabled() && log.isTraceEnabled()) {
                log.trace("found matching method " + clazz.getName() + "." + methodName);
            }
            return candidate;
        }
        if (clazz.getSuperclass() != null) {
            return ReflectUtil.findMethod(clazz.getSuperclass(), methodName, argDescriptors, args);
        }
        return null;
    }

    public static Constructor<?> findConstructor(Class<?> clazz, List<ArgDescriptor> argDescriptors, Object[] args) {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (!ReflectUtil.isArgumentMatch(constructors[i].getParameterTypes(), argDescriptors, args)) continue;
            return constructors[i];
        }
        return null;
    }

    public static boolean isArgumentMatch(Class<?>[] parameterTypes, List<ArgDescriptor> argDescriptors, Object[] args) {
        int nbrOfArgs = 0;
        if (args != null) {
            nbrOfArgs = args.length;
        }
        int nbrOfParameterTypes = 0;
        if (parameterTypes != null) {
            nbrOfParameterTypes = parameterTypes.length;
        }
        if (nbrOfArgs == 0 && nbrOfParameterTypes == 0) {
            return true;
        }
        if (nbrOfArgs != nbrOfParameterTypes) {
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            String argTypeName;
            Class<?> parameterType = parameterTypes[i];
            String string = argTypeName = argDescriptors != null ? argDescriptors.get(i).getTypeName() : null;
            if (!(argTypeName != null ? !argTypeName.equals(parameterType.getName()) : args[i] != null && !parameterType.isAssignableFrom(args[i].getClass()))) continue;
            return false;
        }
        return true;
    }

    public static String getSignature(String methodName, List<ArgDescriptor> argDescriptors, Object[] args) {
        String signature = methodName + "(";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                ArgDescriptor argDescriptor;
                String argType = null;
                if (argDescriptors != null && (argDescriptor = argDescriptors.get(i)) != null && argDescriptor.getTypeName() != null) {
                    argType = argDescriptor.getTypeName();
                }
                if (argType == null && args[i] != null) {
                    argType = args[i].getClass().getName();
                }
                signature = signature + argType;
                if (i >= args.length - 1) continue;
                signature = signature + ", ";
            }
        }
        signature = signature + ")";
        return signature;
    }

    public static String getUnqualifiedClassName(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ReflectUtil.getUnqualifiedClassName(clazz.getSimpleName());
    }

    public static String getUnqualifiedClassName(String className) {
        if (className == null) {
            return null;
        }
        int dotIndex = className.lastIndexOf(46);
        if (dotIndex != -1) {
            className = className.substring(dotIndex + 1);
        }
        return className;
    }

    public static ClassLoader installDeploymentClassLoader(ProcessDefinitionImpl processDefinition) {
        String deploymentId = processDefinition.getDeploymentId();
        if (deploymentId == null) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader original = currentThread.getContextClassLoader();
        RepositoryCache repositoryCache = EnvironmentImpl.getFromCurrent(RepositoryCache.class);
        DeploymentClassLoader deploymentClassLoader = repositoryCache.getDeploymentClassLoader(deploymentId, original);
        if (deploymentClassLoader == null) {
            deploymentClassLoader = new DeploymentClassLoader(original, deploymentId);
            repositoryCache.setDeploymentClassLoader(deploymentId, original, deploymentClassLoader);
        }
        currentThread.setContextClassLoader(deploymentClassLoader);
        return original;
    }

    public static void uninstallDeploymentClassLoader(ClassLoader original) {
        if (original != null) {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object instantiateUserCode(Descriptor descriptor, ProcessDefinitionImpl processDefinition) {
        ClassLoader classLoader = ReflectUtil.installDeploymentClassLoader(processDefinition);
        try {
            Object object = WireContext.create(descriptor);
            return object;
        }
        finally {
            ReflectUtil.uninstallDeploymentClassLoader(classLoader);
        }
    }
}

