/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.builder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.invoker.Invoker;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessorBuilder;
import org.mule.api.service.ServiceAware;
import org.mule.module.cxf.CxfConfiguration;
import org.mule.module.cxf.CxfInboundMessageProcessor;
import org.mule.module.cxf.MuleInvoker;
import org.mule.module.cxf.support.CxfUtils;
import org.mule.module.cxf.support.MuleHeadersInInterceptor;
import org.mule.module.cxf.support.MuleHeadersOutInterceptor;
import org.mule.module.cxf.support.MuleProtocolHeadersOutInterceptor;
import org.mule.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInboundMessageProcessorBuilder
implements MuleContextAware,
MessageProcessorBuilder {
    private CxfConfiguration configuration;
    private Server server;
    private boolean enableMuleSoapHeaders = true;
    private String wsdlLocation;
    private String bindingId;
    private String mtomEnabled;
    private String service;
    private String namespace;
    private List<AbstractFeature> features;
    private List<Interceptor> inInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> inFaultInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> outInterceptors = new CopyOnWriteArrayList<Interceptor>();
    private List<Interceptor> outFaultInterceptors = new CopyOnWriteArrayList<Interceptor>();
    protected MuleContext muleContext;
    private String port;
    private Map<String, Object> properties;

    public CxfInboundMessageProcessor build() throws MuleException {
        ServerFactoryBean sfb;
        if (this.muleContext == null) {
            throw new IllegalStateException("MuleContext must be supplied.");
        }
        if (this.configuration == null) {
            this.configuration = CxfConfiguration.getConfiguration(this.muleContext);
        }
        if (this.configuration == null) {
            throw new IllegalStateException("A CxfConfiguration object must be supplied.");
        }
        try {
            sfb = this.createServerFactory();
        }
        catch (Exception e) {
            throw new DefaultMuleException((Throwable)e);
        }
        if (this.bindingId != null) {
            sfb.setBindingId(this.bindingId);
        }
        if (this.features != null) {
            sfb.getFeatures().addAll(this.features);
        }
        if (this.mtomEnabled != null) {
            HashMap<String, String> properties = sfb.getProperties();
            if (properties == null) {
                properties = new HashMap<String, String>();
                sfb.setProperties(properties);
            }
            properties.put("mtom-enabled", this.mtomEnabled);
            properties.put("write.attachments", (String)((Object)Boolean.valueOf(true)));
        }
        if (this.inInterceptors != null) {
            sfb.getInInterceptors().addAll(this.inInterceptors);
        }
        if (this.inFaultInterceptors != null) {
            sfb.getInFaultInterceptors().addAll(this.inFaultInterceptors);
        }
        if (this.outInterceptors != null) {
            sfb.getOutInterceptors().addAll(this.outInterceptors);
        }
        if (this.outFaultInterceptors != null) {
            sfb.getOutFaultInterceptors().addAll(this.outFaultInterceptors);
        }
        if (this.enableMuleSoapHeaders) {
            sfb.getInInterceptors().add(new MuleHeadersInInterceptor());
            sfb.getInFaultInterceptors().add(new MuleHeadersInInterceptor());
            sfb.getOutInterceptors().add(new MuleHeadersOutInterceptor());
            sfb.getOutFaultInterceptors().add(new MuleHeadersOutInterceptor());
        }
        sfb.getOutInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        sfb.getOutFaultInterceptors().add(new MuleProtocolHeadersOutInterceptor());
        sfb.setAddress(this.getAddress());
        if (this.wsdlLocation != null) {
            sfb.setWsdlURL(this.wsdlLocation);
        }
        ReflectionServiceFactoryBean svcFac = sfb.getServiceFactory();
        this.addIgnoredMethods(svcFac, Callable.class.getName());
        this.addIgnoredMethods(svcFac, Initialisable.class.getName());
        this.addIgnoredMethods(svcFac, Disposable.class.getName());
        this.addIgnoredMethods(svcFac, ServiceAware.class.getName());
        this.initServiceName(this.getServiceClass(), this.service, this.namespace, svcFac);
        CxfInboundMessageProcessor processor = new CxfInboundMessageProcessor();
        this.configureMessageProcessor(sfb, processor);
        sfb.setStart(false);
        Bus bus = this.configuration.getCxfBus();
        sfb.setBus(bus);
        sfb.getServiceFactory().setBus(bus);
        Configurer configurer = (Configurer)bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(sfb.getServiceFactory().getEndpointName().toString(), (Object)sfb);
        }
        sfb.setProperties(this.properties);
        sfb.setInvoker((Invoker)new MuleInvoker(processor, this.getServiceClass()));
        this.server = sfb.create();
        CxfUtils.removeInterceptor(this.server.getEndpoint().getService().getInInterceptors(), OneWayProcessorInterceptor.class.getName());
        this.configureServer(this.server);
        processor.setBus(sfb.getBus());
        processor.setServer(this.server);
        processor.setProxy(this.isProxy());
        return processor;
    }

    protected void configureServer(Server server2) {
    }

    protected abstract Class<?> getServiceClass();

    protected void configureMessageProcessor(ServerFactoryBean sfb, CxfInboundMessageProcessor processor) {
    }

    protected abstract ServerFactoryBean createServerFactory() throws Exception;

    protected String getAddress() {
        return "http://internalMuleCxfRegistry/" + this.hashCode();
    }

    private void initServiceName(Class<?> exposedInterface, String name, String namespace, ReflectionServiceFactoryBean svcFac) {
        svcFac.setServiceClass(exposedInterface);
        for (AbstractServiceConfiguration c : svcFac.getServiceConfigurations()) {
            c.setServiceFactory(svcFac);
        }
        if (name != null && namespace == null) {
            namespace = svcFac.getServiceQName().getNamespaceURI();
        } else if (name == null && namespace != null) {
            name = svcFac.getServiceQName().getLocalPart();
        }
        if (name != null) {
            svcFac.setServiceName(new QName(namespace, name));
        }
    }

    public void addIgnoredMethods(ReflectionServiceFactoryBean svcFac, String className) {
        try {
            Class c = ClassUtils.loadClass((String)className, this.getClass());
            for (int i = 0; i < c.getMethods().length; ++i) {
                svcFac.getIgnoredMethods().add(c.getMethods()[i]);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public Server getServer() {
        return this.server;
    }

    public abstract boolean isProxy();

    public CxfConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CxfConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean isEnableMuleSoapHeaders() {
        return this.enableMuleSoapHeaders;
    }

    public void setEnableMuleSoapHeaders(boolean enableMuleSoapHeaders) {
        this.enableMuleSoapHeaders = enableMuleSoapHeaders;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setWsdlLocation(String wsdlUrl) {
        this.wsdlLocation = wsdlUrl;
    }

    public String getBindingId() {
        return this.bindingId;
    }

    public void setBindingId(String bindingId) {
        this.bindingId = bindingId;
    }

    public String getMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(String mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String name) {
        this.service = name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public List<Interceptor> getInInterceptors() {
        return this.inInterceptors;
    }

    public void setInInterceptors(List<Interceptor> inInterceptors) {
        this.inInterceptors = inInterceptors;
    }

    public List<Interceptor> getInFaultInterceptors() {
        return this.inFaultInterceptors;
    }

    public void setInFaultInterceptors(List<Interceptor> inFaultInterceptors) {
        this.inFaultInterceptors = inFaultInterceptors;
    }

    public List<Interceptor> getOutInterceptors() {
        return this.outInterceptors;
    }

    public void setOutInterceptors(List<Interceptor> outInterceptors) {
        this.outInterceptors = outInterceptors;
    }

    public List<Interceptor> getOutFaultInterceptors() {
        return this.outFaultInterceptors;
    }

    public void setOutFaultInterceptors(List<Interceptor> outFaultInterceptors) {
        this.outFaultInterceptors = outFaultInterceptors;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String endpoint) {
        this.port = endpoint;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

