/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject;

import com.google.inject.Binder;
import com.google.inject.ConstructorInjector;
import com.google.inject.Injector;
import com.google.inject.InjectorImpl;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.ImmutableSet;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.Preconditions;
import com.google.inject.internal.Scoping;
import com.google.inject.internal.ToStringBuilder;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.CachedValue;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.InjectionPoint;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T> {
    private final Factory<T> factory;

    private ConstructorBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> scopedFactory, Scoping scoping, Factory<T> factory) {
        super(injector, key, source, scopedFactory, scoping);
        this.factory = factory;
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injector, Key<T> key, Object source, Scoping scoping) {
        Factory factoryFactory = new Factory();
        InternalFactory<T> scopedFactory = Scopes.scope(key, injector, factoryFactory, scoping);
        return new ConstructorBindingImpl<T>(injector, key, source, scopedFactory, scoping, factoryFactory);
    }

    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        ((Factory)this.factory).constructorInjector = injector.constructors.get(this.getKey().getTypeLiteral(), errors);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "not initialized");
        return visitor.visit(this);
    }

    @Override
    public InjectionPoint getConstructor() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
    }

    @Override
    public Set<InjectionPoint> getInjectableMembers() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getInjectableMembers();
    }

    @Override
    public Map<Method, List<MethodInterceptor>> getMethodInterceptors() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getMethodInterceptors();
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Dependency.forInjectionPoints(new ImmutableSet.Builder<InjectionPoint>().add(this.getConstructor()).addAll(this.getInjectableMembers()).build());
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ConstructorBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory<T>
    implements InternalFactory<T>,
    CachedValue<T> {
        private ConstructorInjector<T> constructorInjector;

        private Factory() {
        }

        @Override
        public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
            Preconditions.checkState(this.constructorInjector != null, "Constructor not ready");
            return (T)this.constructorInjector.construct(errors, context, dependency.getKey().getRawType());
        }

        @Override
        public T getCachedValue() {
            return this.constructorInjector.getCachedValue();
        }
    }
}

