/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl.ast;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.misc.TypeConversions;
import de.odysseus.el.tree.Bindings;
import de.odysseus.el.tree.impl.ast.AstNode;
import de.odysseus.el.tree.impl.ast.AstRightValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstMethod
extends AstRightValue {
    private final AstNode prefix;
    private final String name;
    private final List<AstNode> nodes;

    public AstMethod(AstNode astNode, String string, List<AstNode> list) {
        this.prefix = astNode;
        this.nodes = list;
        this.name = string;
    }

    @Override
    public Object eval(Bindings bindings, ELContext eLContext) {
        Object object = this.prefix.eval(bindings, eLContext);
        if (object == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.base.null", this.prefix));
        }
        Object object2 = null;
        try {
            object2 = eLContext.getELResolver().getValue(eLContext, object, (Object)this.name);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", this.name, object.getClass()));
        }
        if (!eLContext.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.resolve", this.name, object.getClass()));
        }
        Method method = null;
        if (object2 instanceof Method) {
            method = (Method)object2;
        } else if (object2 instanceof MethodInfo) {
            try {
                method = object2.getClass().getMethod(this.name, ((MethodInfo)object2).getParamTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", this.name, object.getClass()), (Throwable)noSuchMethodException);
            }
        } else {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", this.name, object.getClass()));
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (this.nodes == null && classArray.length > 0 || this.nodes != null && this.nodes.size() != classArray.length) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", this.name, object.getClass()));
        }
        Object[] objectArray = null;
        if (classArray.length > 0) {
            objectArray = new Object[classArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = this.nodes.get(i).eval(bindings, eLContext);
                if (object3 == null && !classArray[i].isPrimitive()) continue;
                objectArray[i] = TypeConversions.coerceToType(object3, classArray[i]);
            }
        }
        try {
            return method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ELException(LocalMessages.get("error.property.method.access", this.name, object.getClass()));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ELException(LocalMessages.get("error.property.method.invocation", this.name, object.getClass()), invocationTargetException.getCause());
        }
    }

    public String toString() {
        return ". " + this.name + "(...)";
    }

    @Override
    public void appendStructure(StringBuilder stringBuilder, Bindings bindings) {
        this.prefix.appendStructure(stringBuilder, bindings);
        stringBuilder.append(".");
        stringBuilder.append(this.name);
        stringBuilder.append("(");
        if (this.nodes != null && this.nodes.size() > 0) {
            this.nodes.get(0).appendStructure(stringBuilder, bindings);
            for (int i = 1; i < this.nodes.size(); ++i) {
                stringBuilder.append(", ");
                this.nodes.get(i).appendStructure(stringBuilder, bindings);
            }
        }
        stringBuilder.append(")");
    }

    @Override
    public int getCardinality() {
        return this.nodes == null ? 1 : this.nodes.size() + 1;
    }

    @Override
    public AstNode getChild(int n) {
        return n == 0 ? this.prefix : (this.nodes == null ? null : this.nodes.get(n - 1));
    }
}

