/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.soap;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.Callable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.api.service.ServiceAware;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.IOUtils;
import org.mule.util.StringUtils;

public class WSProxyService
implements Callable,
ServiceAware,
Initialisable {
    private String urlWebservice;
    private String wsdlEndpoint;
    private String wsdlFile;
    private String wsdlFileContents;
    private boolean useFile = false;
    private Service service;
    private static final String HTTP_REQUEST = "http.request";
    private static final String WSDL_PARAM_1 = "?wsdl";
    private static final String WSDL_PARAM_2 = "&wsdl";
    private boolean lazyInit = true;
    protected static transient Log logger = LogFactory.getLog(WSProxyService.class);

    public String getWsdlEndpoint() {
        return this.wsdlEndpoint;
    }

    public void setWsdlEndpoint(String urlWsdl) {
        this.wsdlEndpoint = urlWsdl;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public Object onCall(MuleEventContext eventContext) throws Exception {
        MuleMessage message;
        String httpRequest;
        if (this.wsdlEndpoint == null && this.lazyInit) {
            this.initialise();
        }
        if ((httpRequest = ((String)(message = eventContext.getMessage()).getInboundProperty(HTTP_REQUEST)).toLowerCase()).indexOf(WSDL_PARAM_1) != -1 || httpRequest.indexOf(WSDL_PARAM_2) != -1) {
            String proxyWSDLURI;
            logger.debug((Object)"Retrieving WSDL from web service");
            if (this.useFile) {
                eventContext.setStopFurtherProcessing(true);
                return this.wsdlFileContents;
            }
            MuleContext muleContext = eventContext.getMuleContext();
            InboundEndpoint webServiceEndpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint(this.wsdlEndpoint);
            MuleMessage replyWSDL = eventContext.requestEvent(webServiceEndpoint, (long)eventContext.getTimeout());
            String wsdlString = replyWSDL.getPayloadAsString();
            String realWSDLURI = this.wsdlEndpoint.split("\\?")[0];
            if ((wsdlString = wsdlString.replaceAll(realWSDLURI, proxyWSDLURI = eventContext.getEndpointURI().toString())).indexOf("localhost") > -1) {
                wsdlString = wsdlString.replaceAll("localhost", InetAddress.getLocalHost().getHostName());
            }
            DefaultMuleMessage modifiedWsdl = new DefaultMuleMessage((Object)wsdlString, muleContext);
            logger.debug((Object)"WSDL retrieved successfully");
            eventContext.setStopFurtherProcessing(true);
            return modifiedWsdl;
        }
        logger.debug((Object)"Forwarding SOAP message");
        return eventContext.getMessage().getPayload();
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void initialise() throws InitialisationException {
        if (this.service != null) {
            OutboundRouter router = null;
            if (this.service.getOutboundMessageProcessor() instanceof OutboundRouterCollection) {
                router = (OutboundRouter)((OutboundRouterCollection)this.service.getOutboundMessageProcessor()).getRoutes().get(0);
            } else if (this.service.getOutboundMessageProcessor() instanceof OutboundRouter) {
                router = (OutboundRouter)this.service.getOutboundMessageProcessor();
            } else {
                throw new IllegalStateException("WSProxyService is only supported when using an OutboundRouter");
            }
            ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getRoutes().get(0);
            this.urlWebservice = endpoint.getEndpointURI().getAddress();
            int paramIndex = this.urlWebservice.indexOf("?");
            if (paramIndex != -1) {
                this.urlWebservice = this.urlWebservice.substring(0, paramIndex);
            }
            if (StringUtils.isNotBlank((String)this.wsdlFile)) {
                try {
                    this.wsdlFileContents = IOUtils.getResourceAsString((String)this.wsdlFile, this.getClass());
                    if (StringUtils.isNotBlank((String)this.wsdlFileContents)) {
                        this.useFile = true;
                        logger.info((Object)("Using file " + this.wsdlFile + " as WSDL file"));
                    }
                }
                catch (IOException fileError) {
                    throw new InitialisationException(CoreMessages.failedToLoad((String)this.wsdlFile), (Initialisable)this);
                }
            }
            if (!this.useFile) {
                if (StringUtils.isBlank((String)this.wsdlEndpoint)) {
                    if (this.urlWebservice == null) {
                        throw new InitialisationException(MessageFactory.createStaticMessage((String)"urlWebservice has not been set, service has not been initialized properly"), (Initialisable)this);
                    }
                    this.wsdlEndpoint = this.urlWebservice.concat(WSDL_PARAM_1);
                    logger.info((Object)("Defaulting to: " + this.wsdlEndpoint));
                } else {
                    logger.info((Object)("Using url " + this.wsdlEndpoint + " as WSDL"));
                }
            }
        } else if (!this.lazyInit) {
            logger.debug((Object)"Service has not yet been injected, lazy initialization will be used.");
            this.lazyInit = true;
        } else {
            throw new InitialisationException(MessageFactory.createStaticMessage((String)"Service not set, this service has not been initialized properly."), (Initialisable)this);
        }
    }
}

